<?php
/**
 * Customize My Account Module Class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Modules\GiftCard;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Traits\SingletonTrait;

defined( 'ABSPATH' ) || exit();

/**
 * Back-order Module Class.
 */
class GiftCardAjax {
	/**
	 * Singleton Trait.
	 */
	use SingletonTrait;

	/**
	 * Module Class Constructor.
	 */
	private function __construct() {
		add_action( 'wp_ajax_rtsb_redeem_gift_card', [ $this, 'redeem_gift_card' ] );
		add_action( 'wp_ajax_nopriv_rtsb_redeem_gift_card', [ $this, 'redeem_gift_card' ] );
		// Send Gift Card.
		add_action( 'wp_ajax_rtsb_send_gift_card_email', [ $this, 'rtsb_send_gift_card_email' ] );
		/* Ajax action for applying a gift card to the cart */
		add_action( 'wp_ajax_rtsb_remove_gift_card_code', [ $this, 'remove_gift_card_code_callback' ] );
		add_action( 'wp_ajax_nopriv_rtsb_remove_gift_card_code', [ $this, 'remove_gift_card_code_callback' ] );
	}

	/**
	 * Check if the gift card code provided is valid and store the amount for
	 * applying the discount to the cart
	 */
	public function remove_gift_card_code_callback() {
		if ( ! wp_verify_nonce( Fns::get_nonce(), rtsb()->nonceText ) ) {
			wp_send_json_error();
		}
		$cardNumber = sanitize_text_field( wp_unslash( $_REQUEST['card_number'] ?? '' ) );

		if ( empty( $cardNumber ) ) {
			wc_add_notice( __( 'Empty Gift Card', 'shopbuilder-pro' ), 'error' );
			wp_send_json_error();
		}
		// Store in session.
		$gift_cards = GiftCardFns::get_gift_cards_from_session();
		unset( $gift_cards[ $cardNumber ] );
		WC()->session->set( 'rtsb_gift_card_code', $gift_cards );
		wc_add_notice( __( 'Gift card remove successfully!', 'shopbuilder-pro' ) );
		wp_send_json_success( [ 'message' => __( 'Gift card Remove!', 'shopbuilder-pro' ) ] );
	}

	/**
	 * Add the "Gift card" type to the WooCommerce product type selector.
	 *
	 * @param array $types The current product types.
	 *
	 * @return array Modified product types array.
	 */
	/**
	 * Apply the gift card.
	 */
	public function rtsb_send_gift_card_email() {
		if ( ! wp_verify_nonce( Fns::get_nonce(), rtsb()->nonceText ) ) {
			wp_send_json_error( [ 'message' => esc_html__( 'Invalid Gift Card!', 'shopbuilder-pro' ) ] );
		}
		$id = sanitize_text_field( wp_unslash( $_REQUEST['card_id'] ?? '' ) );
		if ( empty( $id ) ) {
			wp_send_json_error( [ 'message' => esc_html__( 'Invalid Gift Card!', 'shopbuilder-pro' ) ] );
		}
		$giftCard = GiftCardFns::get_card_by_id( $id );
		if ( ! $giftCard->is_valid() ) {
			wp_send_json_error( [ 'message' => esc_html__( 'Invalid Gift Card!', 'shopbuilder-pro' ) ] );
		}

		$giftCard = GiftCardFns::get_card_by_id( $id );
		if ( ! $giftCard->is_virtual() ) {
			wp_send_json_error( [ 'message' => esc_html__( 'It\'s Not Virtual Gift Card!', 'shopbuilder-pro' ) ] );
		}
		$order_id = $giftCard->get_card_data( 'order_id' );
		WC()->mailer();
		do_action( 'rtsb/gift/card/after/publish', $id, $order_id, 'publish' );
		/*
		 *
		$gift_card_balance = $giftCard->card_balance();
		if ( ! ( $gift_card_balance > 0 ) ) {
			wp_send_json_error( [ 'message' => esc_html__( 'Insufficient balance!', 'shopbuilder-pro' ) ] );
		}
		*/

		wp_send_json_success( [ 'message' => esc_html__( 'Gift card send!', 'shopbuilder-pro' ) ] );
	}
	/**
	 * Add the "Gift card" type to the WooCommerce product type selector.
	 *
	 * @param array $types The current product types.
	 *
	 * @return array Modified product types array.
	 */
	/**
	 * Apply the gift card.
	 */
	public function redeem_gift_card() {
		if ( ! wp_verify_nonce( Fns::get_nonce(), rtsb()->nonceText ) ) {
			wc_add_notice( __( 'Invalid Gift Card!', 'shopbuilder-pro' ), 'error' );
			wp_send_json_error( [ 'message' => esc_html__( 'Invalid Gift Card!', 'shopbuilder-pro' ) ] );
		}
		$cardNumber = sanitize_text_field( wp_unslash( $_REQUEST['card_number'] ?? '' ) );
		if ( empty( $cardNumber ) ) {
			wc_add_notice( __( 'Invalid Gift Card!', 'shopbuilder-pro' ), 'error' );
			wp_send_json_error( [ 'message' => esc_html__( 'Invalid Gift Card!', 'shopbuilder-pro' ) ] );
		}
		$giftCard = GiftCardFns::get_card_by_code( $cardNumber );
		if ( ! $giftCard->is_valid() ) {
			wc_add_notice( __( 'Invalid Gift Card!', 'shopbuilder-pro' ), 'error' );
			wp_send_json_error( [ 'message' => esc_html__( 'Invalid Gift Card!', 'shopbuilder-pro' ) ] );
		}
		$gift_card_balance = $giftCard->card_balance();
		if ( ! ( $gift_card_balance > 0 ) ) {
			wc_add_notice( __( 'Insufficient balance!', 'shopbuilder-pro' ), 'error' );
			wp_send_json_error( [ 'message' => esc_html__( 'Insufficient balance!', 'shopbuilder-pro' ) ] );
		}
		// Store in session.
		$gift_cards                = GiftCardFns::get_gift_cards_from_session();
		$gift_cards[ $cardNumber ] = $gift_card_balance;
		WC()->session->set( 'rtsb_gift_card_code', $gift_cards );
		wc_add_notice( __( 'Gift card applied successfully!', 'shopbuilder-pro' ), 'success' );
		wp_send_json_success( [ 'message' => esc_html__( 'Gift card applied successfully!', 'shopbuilder-pro' ) ] );
	}
}
