<?php
/**
 * Gift Card WooCommerce Product Class.
 *
 * Extends the WC_Product class to define a custom gift card product type.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Modules\GiftCard;

class GiftCardWCProduct extends \WC_Product {

	/**
	 * Constructor for the Gift Card product type.
	 *
	 * @param int|\WC_Product $product The product ID or product object.
	 */
	public function __construct( $product ) {
		parent::__construct( $product );
	}

	/**
	 * Gets the product type for this custom gift card product.
	 *
	 * @return string The gift card product type key.
	 */
	public function get_type() {
		return GiftCardFns::GIFT_CARD_KEY;
	}


}
