<?php
/**
 * Gift Card Product Options
 */


use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Helpers\AdminInputsFns;
use RadiusTheme\SBPRO\Modules\GiftCard\GiftCardFns;

global $thepostid;
?>
<div id="<?php echo esc_attr( GiftCardFns::GIFT_CARD_KEY ); ?>" class="panel woocommerce_options_panel show_if_rtsb-gift-card">
	<div class="rtsb-plugin-ui rtsb-product-edit-page-amount-options ">
		<div class="rtsb-group-heading">
			<h2 class="rtsb-product-edit-page-options-title ">
				<?php echo esc_html_x( 'Gift Card Options', '[Admin] Gift Card Options in product edit page', 'shopbuilder-pro' ); ?>
			</h2>
		</div>
		<div class="form-field rtsb-amounts-list">
			<label for="gift_card-amount">Gift Card Amounts</label>
			<div class="rtsb-variation-amount-list-wrapper">
				<span class="rtsb-add-new-amount-section">
					<input type="number" min="0" id="rtsb_gift_card_amount" name="rtsb_gift_card_amounts[]" class="short wc_input_price gift-card-amount">
					<span class="rtsb-currency-symbol-enter-amount">$</span>
					<a href="#" class="rtsb-add-new-amount"> + Add </a>
					<span class="rtsb-tooltip-container rtsb-amount-already-added hidden">Amount value already used</span>
					<span class="rtsb-tooltip-container rtsb-invalid-amount hidden">Enter a valid amount</span>
				</span>
				<span class="rtsb-variation-amount-list">
					<?php
						$get_post_meta = get_post_meta( $thepostid, GiftCardFns::GIFT_CARD_AMOUNTS, true );
					if ( ! empty( $get_post_meta ) && is_array( $get_post_meta ) ) {
						$get_post_meta = array_unique( $get_post_meta );
						foreach ( $get_post_meta as $key => $value ) {
							?>
							<span class="variation-amount" data-amount="<?php echo esc_attr( $value ); ?>">
								<span class="rtsb-currency-symbol-enter-amount">$</span>
								<input type="number" min="0" readonly class="gift-card-amount" name="rtsb_gift_card_amounts[]" value="<?php echo esc_attr( $value ); ?>">
								<a class="rtsb-remove-amount" href=""><span class="dashicons dashicons-dismiss"></span></a>
							</span>
							<?php
						}
					}
					?>
				</span>

			</div>
		</div>
		<?php
		$validity = get_post_meta( $thepostid, '_rtsb_gift_card_validity', true );
		$fields   = AdminInputsFns::generate_number_input(
			[
				'id'            => 'rtsb_gift_card_validity',
				'label'         => esc_html__( 'Validity Period (Days)', 'shopbuilder-pro' ),
				'desc_tip'      => true,
				'aria_label'    => esc_html__( 'The Gift Card will automatically expire after the specified number of days from the purchase date.', 'shopbuilder-pro' ),
				'description'   => esc_html__( 'The Gift Card will automatically expire after the specified number of days from the purchase date. Leave empty for unlimited time.', 'shopbuilder-pro' ),
				'value'         => $validity ?? 0,
				'placeholder'   => esc_html__( 'Unlimited', 'shopbuilder-pro' ),
				'min'           => '0',
				'step'          => '1',
				'input_class'   => 'rtsb-gift-card-validity',
				'label_class'   => 'field-label',
				'wrapper_class' => 'form-field minimum-product-qty',
			]
		);
		 Fns::print_html( $fields, true )
		?>
	</div>
</div>
