<?php
/**
 * Main Module Manager Class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Modules;

use RadiusTheme\SBPRO\Helpers\FnsPro;
use RadiusTheme\SBPRO\Modules\GiftCard\GiftCardInit;
use RadiusTheme\SBPRO\Modules\GiftCard\GiftCardFns;
use RadiusTheme\SBPRO\Traits\SingletonTrait;
use RadiusTheme\SBPRO\Modules\AddOns\AddOns;
use RadiusTheme\SBPRO\Modules\AddOns\AddOnsFns;
use RadiusTheme\SBPRO\Modules\MiniCart\MiniCart;
use RadiusTheme\SBPRO\Modules\PreOrder\PreOrder;
use RadiusTheme\SBPRO\Modules\BackOrder\BackOrder;
use RadiusTheme\SBPRO\Modules\MiniCart\MiniCartFns;
use RadiusTheme\SBPRO\Modules\PreOrder\PreOrderFns;
use RadiusTheme\SBPRO\Modules\BogoBxGy\BogoGiftBxGy;
use RadiusTheme\SBPRO\Modules\PartialPay\PartialPay;
use RadiusTheme\SBPRO\Modules\BackOrder\BackOrderFns;
use RadiusTheme\SBPRO\Modules\QuickCheckout\Checkout;
use RadiusTheme\SBPRO\Modules\CurrencySwitcher\CsFns;
use RadiusTheme\SBPRO\Modules\BogoBxGy\BogoGiftBxGyFns;
use RadiusTheme\SBPRO\Modules\PartialPay\PartialPayFns;
use RadiusTheme\SBPRO\Modules\QuickCheckout\CheckoutFns;
use RadiusTheme\SBPRO\Modules\SmartCoupons\SmartCoupons;
use RadiusTheme\SBPRO\Modules\BulkDiscount\BulkDiscount;
use RadiusTheme\SBPRO\Modules\ProductSizeChart\SizeChart;
use RadiusTheme\SBPRO\Modules\FlashSaleCountdown\Countdown;
use RadiusTheme\SBPRO\Modules\SmartCoupons\SmartCouponsFns;
use RadiusTheme\SBPRO\Modules\ProductSizeChart\SizeChartFns;
use RadiusTheme\SBPRO\Modules\CurrencySwitcher\SwitcherInit;
use RadiusTheme\SBPRO\Modules\BulkDiscount\BulkDiscountFns;
use RadiusTheme\SBPRO\Modules\ShopifyCheckout\ShopifyCheckout;
use RadiusTheme\SBPRO\Modules\SalesNotification\Notification;
use RadiusTheme\SBPRO\Modules\CheckoutEditor\CheckoutManager;
use RadiusTheme\SBPRO\Modules\FlashSaleCountdown\CountdownFns;
use RadiusTheme\SBPRO\Modules\StickyAddToCart\StickyAddToCart;
use RadiusTheme\SBPRO\Modules\SalesNotification\NotificationFns;
use RadiusTheme\SBPRO\Modules\StickyAddToCart\StickyAddToCartFns;
use RadiusTheme\SBPRO\Modules\VariationGallery\VariationGalleryInit;
use RadiusTheme\SBPRO\Modules\MultiStepsCheckout\MultiStepsCheckout;
use RadiusTheme\SBPRO\Modules\CustomizeMyAccount\CustomizeMyAccount;
use RadiusTheme\SBPRO\Modules\VariationSwatches\VariationSwatchesInit;
use RadiusTheme\SBPRO\Modules\MultiStepsCheckout\MultiStepsCheckoutFns;
use RadiusTheme\SBPRO\Modules\CustomizeMyAccount\CustomizeMyAccountFns;

defined( 'ABSPATH' ) || exit();

/**
 * Main Module Manager Class.
 */
class ModuleManager {
	/**
	 * Singleton Trait.
	 */
	use SingletonTrait;

	/**
	 * Class construction.
	 */
	private function __construct() {
		add_filter( 'rtsb/module/sales_notification/options', [ __CLASS__, 'sales_notification_options' ], 15 );
		add_filter( 'rtsb/module/flash_sale_countdown/options', [ __CLASS__, 'flash_sale_countdown_options' ], 15 );
		add_filter( 'rtsb/module/mini_cart/options', [ __CLASS__, 'mini_cart_options' ], 15 );
		add_filter( 'rtsb/module/quick_checkout/options', [ __CLASS__, 'quick_checkout_options' ], 15 );
		add_filter( 'rtsb/module/product_size_chart/options', [ __CLASS__, 'product_size_chart_options' ], 15 );
		add_filter( 'rtsb/module/multi_step_checkout/options', [ __CLASS__, 'multi_step_checkout_options' ], 15 );
		add_filter( 'rtsb/module/back_order/options', [ __CLASS__, 'back_order_options' ], 15 );
		add_filter( 'rtsb/module/currency_switcher/options', [ __CLASS__, 'currency_switcher' ], 15 );
		add_filter( 'rtsb/module/pre_order/options', [ __CLASS__, 'pre_order_options' ], 15 );
		add_filter( 'rtsb/module/product_add_ons/options', [ __CLASS__, 'product_add_ons_options' ], 15 );
		add_filter( 'rtsb/module/customize_my_account/options', [ __CLASS__, 'customize_my_account_options' ], 15 );
		add_filter( 'rtsb/module/sticky_add_to_cart/options', [ __CLASS__, 'sticky_add_to_cart_options' ], 15 );
		add_filter( 'rtsb/module/bulk_discounts/options', [ __CLASS__, 'bulk_discounts' ], 15 );
		add_filter( 'rtsb/module/bogo_bxgy_free_gift_discounts/options', [ __CLASS__, 'bogo_bxgy_free_gift_discounts' ], 15 );
		add_filter( 'rtsb/module/partial_pay/options', [ __CLASS__, 'partial_pay_options' ], 15 );
		add_filter( 'rtsb/module/smart_coupons/options', [ __CLASS__, 'smart_coupons_options' ], 15 );

		// Checkout Editor Init.
		add_action( 'rtsb/checkout/editor/init', [ __CLASS__, 'module_base_hooks' ], 15 );
		add_action( 'rtsb/loaded/shopify/checkout', [ __CLASS__, 'shopify_checkout' ] );
		add_action( 'rtsb/module/gift_card/options', [ __CLASS__, 'gift_card_options' ] );
		// Variation Swatches Init.
		add_action( 'rtsb/variation/swatches/init', [ __CLASS__, 'variation_swatches_init' ] );
		add_action( 'rtsb/variation/gallery/init', [ __CLASS__, 'variation_gallery_init' ] );
	}
	/**
	 * @return void
	 */
	public static function variation_gallery_init() {
		VariationGalleryInit::instance();
	}
	/**
	 * @return void
	 */
	public static function variation_swatches_init() {
		VariationSwatchesInit::instance();
	}
	/**
	 * @return void
	 */
	public static function shopify_checkout() {
		ShopifyCheckout::instance();
	}
	/**
	 * @return void
	 */
	public static function module_base_hooks() {
		if ( FnsPro::is_module_active( 'checkout_fields_editor' ) ) {
			CheckoutManager::instance();
		}
	}
	/**
	 * Sales notification module options.
	 *
	 * @param array $options Module Options.
	 *
	 * @return array
	 */
	public static function sales_notification_options( $options ) {
		$options['base_class'] = Notification::class;
		$options['fields']     = NotificationFns::settings_field();
		$options['tabs']       = [
			'general' => [
				'title' => esc_html__( 'General', 'shopbuilder-pro' ),
			],
			'filter'  => [
				'title' => esc_html__( 'Visibility', 'shopbuilder-pro' ),
			],
			'style'   => [
				'title' => esc_html__( 'Style', 'shopbuilder-pro' ),
			],
		];

		return $options;
	}

	/**
	 * Flash sale countdown module options.
	 *
	 * @param array $options Module Options.
	 *
	 * @return array
	 */
	public static function flash_sale_countdown_options( $options ) {
		$options['base_class'] = Countdown::class;
		$options['fields']     = CountdownFns::settings_field();
		$options['tabs']       = [
			'general'  => [
				'title' => esc_html__( 'General', 'shopbuilder-pro' ),
			],
			'campaign' => [
				'title' => esc_html__( 'Campaign', 'shopbuilder-pro' ),
			],
			'style'    => [
				'title' => esc_html__( 'Style', 'shopbuilder-pro' ),
			],
		];
		return $options;
	}

	/**
	 * Mini-cart module options.
	 *
	 * @param array $options Module Options.
	 *
	 * @return array
	 */
	public static function mini_cart_options( $options ) {
		$options['base_class'] = MiniCart::class;
		$options['fields']     = MiniCartFns::settings_field();
		$options['active']     = 'on';
		$options['tabs']       = [
			'general'         => [
				'title' => esc_html__( 'General', 'shopbuilder-pro' ),
			],
			'filter'          => [
				'title' => esc_html__( 'Visibility', 'shopbuilder-pro' ),
			],
			'floating_button' => [
				'title' => esc_html__( 'Floating Button Style', 'shopbuilder-pro' ),
			],
			'minicart_area'   => [
				'title' => esc_html__( 'Mini Cart Style', 'shopbuilder-pro' ),
			],
		];

		return $options;
	}

	/**
	 * Quick checkout module options.
	 *
	 * @param array $options Module Options.
	 *
	 * @return array
	 */
	public static function quick_checkout_options( $options ) {
		$options['base_class'] = Checkout::class;
		$options['fields']     = CheckoutFns::settings_field();
		$options['tabs']       = [
			'general' => [
				'title' => esc_html__( 'General', 'shopbuilder-pro' ),
			],
			'style'   => [
				'title' => esc_html__( 'Style', 'shopbuilder-pro' ),
			],
		];

		return $options;
	}

	/**
	 * Product size-chart module options.
	 *
	 * @param array $options Module Options.
	 *
	 * @return array
	 */
	public static function product_size_chart_options( $options ) {
		$options['base_class'] = SizeChart::class;
		$options['fields']     = SizeChartFns::settings_field();
		$options['tabs']       = [
			'general' => [
				'title' => esc_html__( 'General', 'shopbuilder-pro' ),
			],
			'chart'   => [
				'title' => esc_html__( 'Chart', 'shopbuilder-pro' ),
			],
			'style'   => [
				'title' => esc_html__( 'Style', 'shopbuilder-pro' ),
			],
		];

		return $options;
	}


	/**
	 * Multi-step checkout module options.
	 *
	 * @param array $options Module Options.
	 *
	 * @return array
	 */
	public static function multi_step_checkout_options( $options ) {
		$options['base_class'] = MultiStepsCheckout::class;
		$options['fields']     = MultiStepsCheckoutFns::settings_field();
		$options['tabs']       = [
			'general'   => [
				'title' => esc_html__( 'General', 'shopbuilder-pro' ),
			],
			'step_icon' => [
				'title' => esc_html__( 'Multi-Step Icon', 'shopbuilder-pro' ),
			],
			'style'     => [
				'title' => esc_html__( 'Style', 'shopbuilder-pro' ),
			],

		];

		return $options;
	}

	/**
	 * Back-order module options.
	 *
	 * @param array $options Module Options.
	 *
	 * @return array
	 */
	public static function back_order_options( $options ) {
		$options['base_class'] = BackOrder::class;
		$options['fields']     = BackOrderFns::settings_field();
		$options['tabs']       = [
			'general' => [
				'title' => esc_html__( 'General', 'shopbuilder-pro' ),
			],
			'styles'  => [
				'title' => esc_html__( 'Styles', 'shopbuilder-pro' ),
			],
		];

		return $options;
	}

	/**
	 * Pre-order module options.
	 *
	 * @param array $options Module Options.
	 *
	 * @return array
	 */
	public static function pre_order_options( $options ) {
		$options['base_class'] = PreOrder::class;
		$options['fields']     = PreOrderFns::settings_field();
		$options['tabs']       = [
			'general'      => [
				'title' => esc_html__( 'General', 'shopbuilder-pro' ),
			],
			'settings'     => [
				'title' => esc_html__( 'Settings', 'shopbuilder-pro' ),
			],
			'notification' => [
				'title' => esc_html__( 'Notifications', 'shopbuilder-pro' ),
			],
			'styles'       => [
				'title' => esc_html__( 'Styles', 'shopbuilder-pro' ),
			],
		];

		return $options;
	}

	/**
	 * Product Add-Ons module options.
	 *
	 * @param array $options Module Options.
	 *
	 * @return array
	 */
	public static function product_add_ons_options( $options ) {
		$options['base_class'] = AddOns::class;
		$options['fields']     = AddOnsFns::settings_field();
		$options['tabs']       = [
			'general' => [
				'title' => esc_html__( 'General', 'shopbuilder-pro' ),
			],
			'add_ons' => [
				'title' => esc_html__( 'Global Add-Ons', 'shopbuilder-pro' ),
			],
			'styles'  => [
				'title' => esc_html__( 'Styles', 'shopbuilder-pro' ),
			],
		];

		return $options;
	}

	/**
	 * Currency Switcher module options.
	 *
	 * @param array $options Module Options.
	 *
	 * @return array
	 */
	public static function currency_switcher( $options ) {
		$options['base_class'] = SwitcherInit::class;
		$options['fields']     = CsFns::settings_field();
		$options['tabs']       = [
			'general'    => [
				'title' => esc_html__( 'General', 'shopbuilder-pro' ),
			],
			'currencies' => [
				'title' => esc_html__( 'Currencies', 'shopbuilder-pro' ),
			],
			'styles'     => [
				'title' => esc_html__( 'Styles', 'shopbuilder-pro' ),
			],
		];

		return $options;
	}
	/**
	 * Customize My Account module options.
	 *
	 * @param array $options Module Options.
	 *
	 * @return array
	 */
	public static function customize_my_account_options( $options ) {
		$options['base_class'] = CustomizeMyAccount::class;
		$options['fields']     = CustomizeMyAccountFns::settings_field();
		$options['tabs']       = [
			'general'   => [
				'title' => esc_html__( 'General', 'shopbuilder-pro' ),
			],
			'endpoints' => [
				'title' => esc_html__( 'Endpoints', 'shopbuilder-pro' ),
			],
			'styles'    => [
				'title' => esc_html__( 'Styles', 'shopbuilder-pro' ),
			],
		];

		return $options;
	}

	/**
	 * Sticky add-to-cart module options.
	 *
	 * @param array $options Module Options.
	 *
	 * @return array
	 */
	public static function sticky_add_to_cart_options( $options ) {
		$options['base_class'] = StickyAddToCart::class;
		$options['fields']     = StickyAddToCartFns::settings_field();
		$options['tabs']       = [
			'general' => [
				'title' => esc_html__( 'General', 'shopbuilder-pro' ),
			],
			'styles'  => [
				'title' => esc_html__( 'Styles', 'shopbuilder-pro' ),
			],
		];

		return $options;
	}

	/**
	 * Smart Coupons module options.
	 *
	 * @param array $options Module Options.
	 *
	 * @return array
	 */
	public static function smart_coupons_options( $options ) {
		$options['base_class'] = SmartCoupons::class;
		$options['fields']     = SmartCouponsFns::settings_field();
		$options['tabs']       = [
			'general' => [
				'title' => esc_html__( 'General', 'shopbuilder-pro' ),
			],
			'styles'  => [
				'title' => esc_html__( 'Shortcode', 'shopbuilder-pro' ),
			],
		];

		return $options;
	}
	/**
	 * Bulk Discount module options.
	 *
	 * @param array $options Module Options.
	 *
	 * @return array
	 */
	public static function bulk_discounts( $options ) {
		$options['base_class'] = BulkDiscount::class;
		$options['fields']     = BulkDiscountFns::settings_field();
		$options['tabs']       = [
			'general' => [
				'title' => esc_html__( 'General', 'shopbuilder-pro' ),
			],
			'rules'   => [
				'title' => esc_html__( 'Create Rules', 'shopbuilder-pro' ),
			],
			'styles'  => [
				'title' => esc_html__( 'General Styles', 'shopbuilder-pro' ),
			],
		];
		return $options;
	}

	/**
	 * Partial Pay module options.
	 *
	 * @param array $options Module Options.
	 *
	 * @return array
	 */
	public static function partial_pay_options( $options ) {
		$options['base_class'] = PartialPay::class;
		$options['fields']     = PartialPayFns::settings_field();
		$options['tabs']       = [
			'general'      => [
				'title' => esc_html__( 'General', 'shopbuilder-pro' ),
			],
			'rules'        => [
				'title' => esc_html__( 'Partial Pay Rules', 'shopbuilder-pro' ),
			],
			'notification' => [
				'title' => esc_html__( 'Notifications', 'shopbuilder-pro' ),
			],
			'styles'       => [
				'title' => esc_html__( 'Styles', 'shopbuilder-pro' ),
			],
		];

		return $options;
	}

	/**
	 * BOGO module options.
	 *
	 * @param array $options Module Options.
	 *
	 * @return array
	 */
	public static function bogo_bxgy_free_gift_discounts( $options ) {
		$options['base_class'] = BogoGiftBxGy::class;
		$options['fields']     = BogoGiftBxGyFns::settings_field();
		$options['tabs']       = [
			'general' => [
				'title' => esc_html__( 'General', 'shopbuilder-pro' ),
			],
			'rules'   => [
				'title' => esc_html__( 'Create Rules', 'shopbuilder-pro' ),
			],
			'styles'  => [
				'title' => esc_html__( 'Styles', 'shopbuilder-pro' ),
			],
		];
		return $options;
	}

	/**
	 * BOGO module options.
	 *
	 * @param array $options Module Options.
	 *
	 * @return array
	 */
	public static function gift_card_options( $options ) {
		$options['base_class'] = GiftCardInit::class;
		$options['fields']     = GiftCardFns::settings_field();
		$options['tabs']       = [
			'general'            => [
				'title' => esc_html__( 'General', 'shopbuilder-pro' ),
			],
			'product'            => [
				'title' => esc_html__( 'Product Page', 'shopbuilder-pro' ),
			],
			'table-styles'       => [
				'title' => esc_html__( 'Table Styles', 'shopbuilder-pro' ),
			],
			'redeem-form-styles' => [
				'title' => esc_html__( 'Redeem Form', 'shopbuilder-pro' ),
			],
		];

		return $options;
	}
}
