<?php
/**
 * Partial Pay Module Frontend Class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Modules\PartialPay;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Traits\SingletonTrait;
use RadiusTheme\SBPRO\Modules\PartialPay\Frontend\CartPage;
use RadiusTheme\SBPRO\Modules\PartialPay\Frontend\ProductPage;
use RadiusTheme\SBPRO\Modules\PartialPay\Frontend\OrderHandler;

defined( 'ABSPATH' ) || exit();

/**
 * Partial Pay Module Frontend Class.
 */
class PartialPayFrontend {
	/**
	 * Singleton Trait.
	 */
	use SingletonTrait;

	/**
	 * Options.
	 *
	 * @var array|mixed
	 */
	private array $options;

	/**
	 * Asset Handle
	 *
	 * @var string
	 */
	private $handle = 'rtsb-partial-pay';

	/**
	 * Module Class Constructor.
	 */
	private function __construct() {
		/**
		 * Get the options.
		 */
		$this->options = Fns::get_options( 'modules', 'partial_pay' );

		/**
		 * Product modifications.
		 */
		ProductPage::instance();

		/**
		 * Cart modifications.
		 */
		CartPage::instance();

		/**
		 * Order data modifications.
		 */
		OrderHandler::instance();

		/**
		 * Global Styles.
		 */
		$this->dynamic_styles();
	}

	/**
	 * Partial Pay dynamic styles.
	 *
	 * @return void
	 */
	private function dynamic_styles() {
		add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_public_scripts' ], 99 );
	}

	/**
	 * Dynamic styles.
	 *
	 * @return void
	 */
	public function enqueue_public_scripts() {
		// Enqueue assets.
		$this->handle = Fns::enqueue_module_assets(
			$this->handle,
			'partial-pay',
			[
				'context' => rtsbpro(),
				'version' => RTSBPRO_VERSION,
			]
		);

		$settings          = Fns::get_options( 'modules', 'partial_pay' );
		$cache_key         = 'rtsb_partial_pay_dynamic_styles_' . md5( wp_json_encode( $settings ) );
		$partial_pay       = '.rtsb-partial-pay-wrapper';
		$partial_pay_badge = '.rtsb-partial-pay-text-badge';
		$partial_pay_radio = $partial_pay . ' .rtsb-option';
		$partial_pay_label = $partial_pay . ' .rtsb-option-title';
		$partial_pay_price = $partial_pay . ' .rtsb-option-price';
		$partial_pay_text  = $partial_pay . ' .rtsb-option-content';
		$partial_pay_note  = '.rtsb-partial-pay-avail-note span';

		// phpcs:disable
		// Disabled phpcs for one-liner display.
		$css_properties = [
			'pp_note_font_size'        => [ 'selector' => $partial_pay_note, 'property' => 'font-size', 'unit' => 'px' ],
			'pp_note_font_color'       => [ 'selector' => $partial_pay_note, 'property' => 'color' ],
			'pp_note_bg_color'         => [ 'selector' => $partial_pay_note, 'property' => 'background-color' ],
			'pp_note_radius'           => [ 'selector' => $partial_pay_note, 'property' => 'border-radius' ],
			'pp_note_padding'          => [ 'selector' => $partial_pay_note, 'property' => 'padding' ],
			'pp_note_margin'           => [ 'selector' => $partial_pay_note, 'property' => 'margin' ],
			'pp_form_primary_color'    => [ 'selector' => $partial_pay, 'property' => '--rtsb-color-primary' ],
			'pp_form_background_color' => [ 'selector' => $partial_pay_radio, 'property' => 'background-color' ],
			'pp_radio_label_color'     => [ 'selector' => $partial_pay_label, 'property' => 'color' ],
			'pp_radio_price_color'     => [ 'selector' => $partial_pay_price, 'property' => 'color' ],
			'pp_field_text_color'      => [ 'selector' => $partial_pay_text, 'property' => 'color' ],
			'pp_form_border_color'     => [ 'selector' => $partial_pay_radio, 'property' => 'border-color' ],
			'pp_radius'                => [ 'selector' => $partial_pay_radio, 'property' => 'border-radius' ],
			'pp_margin'                => [ 'selector' => $partial_pay, 'property' => 'margin' ],
			'pp_badge_text_color'      => [ 'selector' => $partial_pay_badge, 'property' => 'color' ],
			'pp_badge_bg_color'        => [ 'selector' => $partial_pay_badge, 'property' => 'background-color' ],
		];
		// phpcs:enable

		// Generate dynamic CSS.
		Fns::dynamic_styles( $settings, $cache_key, $css_properties );
	}
}
