<?php
/**
 * Pre-order Module Class.
 *
 * @package RadiusTheme\SBPRO
 */

namespace RadiusTheme\SBPRO\Modules\PreOrder;

use RadiusTheme\SBPRO\Traits\SingletonTrait;

defined( 'ABSPATH' ) || exit();

/**
 * Pre-order Module Class.
 */
class PreOrder {
	/**
	 * Singleton Trait.
	 */
	use SingletonTrait;

	/**
	 * Module Class Constructor.
	 */
	private function __construct() {
		PreOrderCommon::instance();
		PreOrderFrontEnd::instance();

		if ( is_admin() ) {
			PreOrderAdmin::instance();
		}
	}
}
