<?php
/**
 * Pre-order Frontend Class.
 *
 * @package RadiusTheme\SBPRO
 */

namespace RadiusTheme\SBPRO\Modules\PreOrder;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Helpers\FnsPro;
use RadiusTheme\SBPRO\Traits\SingletonTrait;
use RadiusTheme\SBPRO\Modules\PreOrder\Frontend\Order;
use RadiusTheme\SBPRO\Modules\PreOrder\Frontend\Product;
use RadiusTheme\SBPRO\Modules\PreOrder\Frontend\CartPage;

defined( 'ABSPATH' ) || exit();

/**
 * Back-order Frontend Class.
 */
class PreOrderFrontEnd {
	/**
	 * Singleton Trait.
	 */
	use SingletonTrait;

	/**
	 * Asset Handle
	 *
	 * @var string
	 */
	private $handle = 'rtsb-pre-order';

	/**
	 * Class Constructor.
	 */
	private function __construct() {
		/**
		 * Product modifications.
		 */
		Product::instance();

		/**
		 * Cart page modifications.
		 */
		CartPage::instance();

		/**
		 * Order modifications.
		 */
		Order::instance();

		/**
		 * Dynamic styles.
		 */
		$this->dynamic_styles();
	}

	/**
	 * Pre-Order dynamic styles.
	 *
	 * @return void
	 */
	private function dynamic_styles() {
		add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_public_scripts' ], 99 );
	}

	/**
	 * Dynamic styles.
	 *
	 * @return void
	 */
	public function enqueue_public_scripts() {
		// Enqueue assets.
		$this->handle = Fns::enqueue_module_assets(
			$this->handle,
			'pre-order',
			[
				'context' => rtsbpro(),
				'version' => RTSBPRO_VERSION,
			]
		);

		$settings               = Fns::get_options( 'modules', 'pre_order' );
		$cache_key              = 'rtsb_preorder_dynamic_styles_' . md5( wp_json_encode( $settings ) );
		$pre_order              = '.available-on-pre-order .rtsb-pre-order-text';
		$pre_order_badge        = '.rtsb-pre-order-text-badge';
		$pre_order_counter      = '.rtsb-pre-order-timer.rtsb-countdown-campaign';
		$pre_order_counter_item = $pre_order_counter . ' .rtsb-countdown-section';

		// phpcs:disable
		// Disabled phpcs for one-liner display.
		$css_properties = [
			'pre_order_text_color'               => [ 'selector' => $pre_order, 'property' => 'color' ],
			'pre_order_bg_color'                 => [ 'selector' => $pre_order, 'property' => 'background-color' ],
			'pre_order_font_size'                => [ 'selector' => $pre_order, 'property' => 'font-size' ],
			'pre_order_font_weight'              => [ 'selector' => $pre_order, 'property' => 'font-weight' ],
			'pre_order_radius'                   => [ 'selector' => $pre_order, 'property' => 'border-radius' ],
			'pre_order_padding'                  => [ 'selector' => $pre_order, 'property' => 'padding' ],
			'pre_order_margin'                   => [ 'selector' => $pre_order, 'property' => 'margin' ],
			'pre_order_badge_text_color'         => [ 'selector' => $pre_order_badge, 'property' => 'color' ],
			'pre_order_badge_bg_color'           => [ 'selector' => $pre_order_badge, 'property' => 'background-color' ],
			'pre_order_counter_background_color' => [ 'selector' => $pre_order_counter_item, 'property' => 'background-color' ],
			'pre_order_counter_text_color'       => [ 'selector' => $pre_order_counter_item, 'property' => 'color' ],
			'pre_order_counter_button_margin'    => [ 'selector' => $pre_order_counter, 'property' => 'margin' ],
		];
		// phpcs:enable

		// Generate dynamic CSS.
		FnsPro::dynamic_styles( $settings, $cache_key, $css_properties, $this->handle );
	}
}
