<?php
/**
 * Main FilterHooks class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Modules\SalesNotification;

use RadiusTheme\SB\Helpers\Fns;

defined( 'ABSPATH' ) || exit();

/**
 * Main FilterHooks class.
 */
class NotificationFns {
	/**
	 * @return array
	 */
	public static function settings_field() {
		return apply_filters(
			'rtsb/module/notification_settings/fields',
			[
				'notification_layout'                   => [
					'id'      => 'notification_layout',
					'type'    => 'select',
					'value'   => 'style-1',
					'label'   => esc_html__( 'Select Notification Layout ', 'shopbuilder-pro' ),
					'options' => [
						'style-1' => esc_html__( 'Layout 1', 'shopbuilder-pro' ),
						'style-2' => esc_html__( 'Layout 2', 'shopbuilder-pro' ),
						'style-3' => esc_html__( 'Layout 3', 'shopbuilder-pro' ),
					],
					'tab'     => 'general',
				],

				'notification_image'                    => [
					'id'      => 'notification_image',
					'type'    => 'select',
					'value'   => 'products-image',
					'label'   => esc_html__( 'Notification Image Type', 'shopbuilder-pro' ),
					'options' => [
						'no-image'       => esc_html__( 'No Image', 'shopbuilder-pro' ),
						'products-image' => esc_html__( 'Products image', 'shopbuilder-pro' ),
						'user-image'     => esc_html__( 'User image', 'shopbuilder-pro' ),
					],
					'tab'     => 'general',
				],

				'notification_number_of_popups'         => [
					'id'    => 'notification_number_of_popups',
					'type'  => 'number',
					'value' => 100,
					'size'  => 'small',
					'min'   => 1,
					'label' => esc_html__( 'Specify the Number of Recent Orders', 'shopbuilder-pro' ),
					'help'  => esc_html__( 'Enter a number to specify the quantity of the latest orders to retrieve the data.', 'shopbuilder-pro' ),
					'tab'   => 'general',
				],

				'notification_cache'                    => [
					'id'    => 'notification_cache',
					'type'  => 'number',
					'size'  => 'small',
					'value' => HOUR_IN_SECONDS,
					'min'   => 1,
					'label' => esc_html__( 'Data Refresh Interval (seconds)', 'shopbuilder-pro' ),
					'help'  => esc_html__( 'Enter the data refresh interval. Data will be regenerated after the specified amount of time in seconds every time.', 'shopbuilder-pro' ),
					'tab'   => 'general',
				],

				'notification_position'                 => [
					'id'      => 'notification_position',
					'type'    => 'select',
					'value'   => 'bottom_left',
					'label'   => esc_html__( 'Notification Popup Position ', 'shopbuilder-pro' ),
					'help'    => esc_html__( 'You can manage notification position.', 'shopbuilder-pro' ),
					'options' => [
						'top_left'     => esc_html__( 'Top left', 'shopbuilder-pro' ),
						'top_right'    => esc_html__( 'Top right', 'shopbuilder-pro' ),
						'bottom_left'  => esc_html__( 'Bottom left', 'shopbuilder-pro' ),
						'bottom_right' => esc_html__( 'Bottom Right', 'shopbuilder-pro' ),
					],
					'tab'     => 'general',
				],

				'notification_animate_for_top_left'     => [
					'id'         => 'notification_animate_for_top_left',
					'type'       => 'select',
					'value'      => 'fadein',
					'label'      => esc_html__( 'Notification Animation', 'shopbuilder-pro' ),
					'help'       => esc_html__( 'You can manage notification animate.', 'shopbuilder-pro' ),
					'options'    => [
						'fadein' => esc_html__( 'Fade In', 'shopbuilder-pro' ),
						'left'   => esc_html__( 'Slide left', 'shopbuilder-pro' ),
						'down'   => esc_html__( 'Slide Down', 'shopbuilder-pro' ),
					],
					'dependency' => [
						'rules' => [
							[
								'item'     => 'modules.sales_notification.notification_position',
								'value'    => 'top_left',
								'operator' => '==',
							],
						],
					],
					'tab'        => 'general',
				],
				'notification_animate_for_top_right'    => [
					'id'         => 'notification_animate_for_top_right',
					'type'       => 'select',
					'value'      => 'fadein',
					'label'      => esc_html__( 'Notification Animation', 'shopbuilder-pro' ),
					'help'       => esc_html__( 'You can manage notification animate.', 'shopbuilder-pro' ),
					'options'    => [
						'fadein' => esc_html__( 'Fade In', 'shopbuilder-pro' ),
						'right'  => esc_html__( 'Slide Right', 'shopbuilder-pro' ),
						'down'   => esc_html__( 'Slide Down', 'shopbuilder-pro' ),
					],
					'dependency' => [
						'rules' => [
							[
								'item'     => 'modules.sales_notification.notification_position',
								'value'    => 'top_right',
								'operator' => '==',
							],
						],
					],
					'tab'        => 'general',
				],
				'notification_animate_for_bottom_left'  => [
					'id'         => 'notification_animate_for_bottom_left',
					'type'       => 'select',
					'value'      => 'fadein',
					'label'      => esc_html__( 'Notification Animation', 'shopbuilder-pro' ),
					'help'       => esc_html__( 'You can manage notification animate.', 'shopbuilder-pro' ),
					'options'    => [
						'fadein' => esc_html__( 'Fade In', 'shopbuilder-pro' ),
						'left'   => esc_html__( 'Slide left', 'shopbuilder-pro' ),
						'up'     => esc_html__( 'Slide Up', 'shopbuilder-pro' ),
					],
					'dependency' => [
						'rules' => [
							[
								'item'     => 'modules.sales_notification.notification_position',
								'value'    => 'bottom_left',
								'operator' => '==',
							],
						],
					],
					'tab'        => 'general',
				],
				'notification_animate_for_bottom_right' => [
					'id'         => 'notification_animate_for_bottom_right',
					'type'       => 'select',
					'value'      => 'fadein',
					'label'      => esc_html__( 'Notification Animation', 'shopbuilder-pro' ),
					'help'       => esc_html__( 'You can manage notification animate.', 'shopbuilder-pro' ),
					'options'    => [
						'fadein' => esc_html__( 'Fade In', 'shopbuilder-pro' ),
						'right'  => esc_html__( 'Slide Right', 'shopbuilder-pro' ),
						'up'     => esc_html__( 'Slide Up', 'shopbuilder-pro' ),
					],
					'dependency' => [
						'rules' => [
							[
								'item'     => 'modules.sales_notification.notification_position',
								'value'    => 'bottom_right',
								'operator' => '==',
							],
						],
					],
					'tab'        => 'general',
				],
				'notification_delay'                    => [
					'id'    => 'notification_delay',
					'type'  => 'number',
					'value' => 5000,
					'size'  => 'small',
					'min'   => 1000,
					'label' => esc_html__( 'Notification Delay (milliseconds)', 'shopbuilder-pro' ),
					'help'  => esc_html__( 'Enter the notification delay in milliseconds.', 'shopbuilder-pro' ),
					'tab'   => 'general',
				],

				'notification_keep_onscreen'            => [
					'id'    => 'notification_keep_onscreen',
					'type'  => 'number',
					'value' => 7000,
					'size'  => 'small',
					'min'   => 1000,
					'label' => esc_html__( 'Notification timeout (milliseconds)', 'shopbuilder-pro' ),
					'help'  => esc_html__( 'Keep notification on screen in specified number in milliseconds.', 'shopbuilder-pro' ),
					'tab'   => 'general',
				],

				'notification_show_close_button'        => [
					'id'    => 'notification_show_close_button',
					'type'  => 'switch',
					'label' => esc_html__( 'Show Close Button', 'shopbuilder-pro' ),
					'help'  => esc_html__( 'Enable this option to Show Close Button.', 'shopbuilder-pro' ),
					'tab'   => 'general',
				],

				'notification_display_user_name'        => [
					'id'    => 'notification_display_user_name',
					'value' => '',
					'type'  => 'switch',
					'label' => esc_html__( 'Display User Name', 'shopbuilder-pro' ),
					'help'  => esc_html__( 'Activate this setting to display the user\'s name in sales notifications.', 'shopbuilder-pro' ),
					'tab'   => 'general',
				],

				'notification_show_on_mobile'           => [
					'id'    => 'notification_show_on_mobile',
					'type'  => 'switch',
					'label' => esc_html__( 'Show On Mobile', 'shopbuilder-pro' ),
					'help'  => esc_html__( 'Enable this option to Show On Mobile.', 'shopbuilder-pro' ),
					'tab'   => 'general',
					'value' => 'on',
				],

				'notification_show_processing_order'    => [
					'id'    => 'notification_show_processing_order',
					'type'  => 'switch',
					'label' => esc_html__( 'Show Orders Currently in Processing Status.', 'shopbuilder-pro' ),
					'help'  => esc_html__( 'Enable this option to Display Orders With Status "Processing".', 'shopbuilder-pro' ),
					'tab'   => 'general',
					'value' => 'on',
				],

				'notification_enable_product_link'      => [
					'id'    => 'notification_enable_product_link',
					'type'  => 'switch',
					'label' => esc_html__( 'Enable Product Link.', 'shopbuilder-pro' ),
					'help'  => esc_html__( 'Enable this option to show with product Link.', 'shopbuilder-pro' ),
					'tab'   => 'general',
					'value' => 'on',
				],

				'notification_product_title_max_words'  => [
					'id'    => 'notification_product_title_max_words',
					'type'  => 'number',
					'value' => 10,
					'size'  => 'small',
					'min'   => 1,
					'label' => esc_html__( 'Product title maximum words', 'shopbuilder-pro' ),
					'tab'   => 'general',
				],
				/*
					The function call_user_func_with_param must be Return array look like
					Default params $search = null
					return [
						[
							'label' => 'label',
							'value' => 'Value'
						],
						[
							'label' => 'label 2',
							'value' => 'Value 2'
						]
					]
				*/
				'notification_include_archive'          => [
					'id'              => 'notification_include_archive',
					'type'            => 'search_and_multi_select',
					'label'           => esc_html__( 'Display in Post Types', 'shopbuilder-pro' ),
					'help'            => esc_html__( 'Select post types to display sales notifications.', 'shopbuilder-pro' ),
					'placeholder'     => esc_html__( 'Search Registered Post type ', 'shopbuilder-pro' ),
					'func_with_param' => [
						Fns::class,
						'get_registered_post_types',
					],
					'options'         => Fns::get_registered_post_types(),
					'tab'             => 'filter',
				],

				'notification_exclude_archive'          => [
					'id'              => 'notification_exclude_archive',
					'type'            => 'search_and_multi_select',
					'label'           => esc_html__( 'Exclude Post Types', 'shopbuilder-pro' ),
					'help'            => esc_html__( 'Select post types to exclude displaying sales notifications.', 'shopbuilder-pro' ),
					'placeholder'     => esc_html__( 'Search Registered Post type ', 'shopbuilder-pro' ),
					'func_with_param' => [
						Fns::class,
						'get_registered_post_types',
					],
					'options'         => Fns::get_registered_post_types(),
					'tab'             => 'filter',
				],

				'notification_include_pages'            => [
					'id'              => 'notification_include_posts',
					'label'           => esc_html__( 'Select Pages to Display Notifications', 'shopbuilder-pro' ),
					'help'            => esc_html__( 'Specify Pages for displaying notifications. All post types are supported.', 'shopbuilder-pro' ),
					'type'            => 'search_and_multi_select',
					'placeholder'     => esc_html__( 'Search Pages', 'shopbuilder-pro' ),
					'func_with_param' => [ Fns::class, 'get_post_types', [ 'post_type' => 'page' ] ],
					'options'         => Fns::get_post_types( null, [ 'post_type' => 'page' ] ),
					'tab'             => 'filter',
				],
				'notification_exclude_pages'            => [
					'id'              => 'notification_exclude_posts',
					'label'           => esc_html__( 'Pages to Exclude Notifications', 'shopbuilder-pro' ),
					'help'            => esc_html__( 'Specify Pages to exclude displaying notifications. All post types are supported.', 'shopbuilder-pro' ),
					'type'            => 'search_and_multi_select',
					'placeholder'     => esc_html__( 'Search Pages', 'shopbuilder-pro' ),
					'func_with_param' => [ Fns::class, 'get_post_types', [ 'post_type' => 'page' ] ],
					'options'         => Fns::get_post_types( null, [ 'post_type' => 'page' ] ),
					'tab'             => 'filter',
				],

				'notification_background_color'         => [
					'id'    => 'notification_background_color',
					'label' => esc_html__( 'Background Color', 'shopbuilder-pro' ),
					'help'  => esc_html__( 'Select notification background color', 'shopbuilder-pro' ),
					'type'  => 'color',
					'tab'   => 'style',
				],

				'notification_link_color'               => [
					'id'    => 'notification_link_color',
					'label' => esc_html__( 'Link Color', 'shopbuilder-pro' ),
					'help'  => esc_html__( 'Select notification link color', 'shopbuilder-pro' ),
					'type'  => 'color',
					'tab'   => 'style',
				],

				'notification_link_hover_color'         => [
					'id'    => 'notification_link_hover_color',
					'label' => esc_html__( 'Link Hover Color', 'shopbuilder-pro' ),
					'help'  => esc_html__( 'Select notification link hover color', 'shopbuilder-pro' ),
					'type'  => 'color',
					'tab'   => 'style',
				],

				'notification_text_color'               => [
					'id'    => 'notification_text_color',
					'label' => esc_html__( 'Text Color', 'shopbuilder-pro' ),
					'help'  => esc_html__( 'Select notification text color', 'shopbuilder-pro' ),
					'type'  => 'color',
					'tab'   => 'style',
				],

				'notification_name_address_color'       => [
					'id'    => 'notification_name_address_color',
					'label' => esc_html__( 'Name Address Color', 'shopbuilder-pro' ),
					'help'  => esc_html__( 'Select notification name-address color', 'shopbuilder-pro' ),
					'type'  => 'color',
					'tab'   => 'style',
				],

				'notification_purchased_time_color'     => [
					'id'    => 'notification_purchased_time_color',
					'label' => esc_html__( 'Purchase Time Color', 'shopbuilder-pro' ),
					'help'  => esc_html__( 'Select notification purchase time color', 'shopbuilder-pro' ),
					'type'  => 'color',
					'tab'   => 'style',
				],

				'notification_cross_button_color'       => [
					'id'    => 'notification_cross_button_color',
					'label' => esc_html__( 'Close Button Color', 'shopbuilder-pro' ),
					'help'  => esc_html__( 'Change close button color', 'shopbuilder-pro' ),
					'type'  => 'color',
					'tab'   => 'style',
				],
			]
		);
	}
}
