<?php
/**
 * Sticky add-to-cart Module Class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Modules\ShopifyCheckout;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Traits\SingletonTrait;

defined( 'ABSPATH' ) || exit();

/**
 * Sticky add-to-cart Module Class.
 */
class ShopifyCheckout {
	/**
	 * Singleton Trait.
	 */
	use SingletonTrait;

	/**
	 * Module Class Constructor.
	 */
	private function __construct() {
		global $shopify_checkout_options;
		if ( 'on' === ( $shopify_checkout_options['enable_multi_step'] ?? 'off' ) ) {
			add_action( 'rtsb/before/shopify/checkout/form', [ $this, 'multi_step_menu' ] );
			add_action( 'rtsb/after/payment/section/shopify/checkout/form', [ $this, 'continue_button' ] );
			add_action( 'wp_enqueue_scripts', [ $this, 'enqueue' ], 99 );
			add_filter( 'woocommerce_order_button_html', '__return_empty_string' );
		}
	}
	/**
	 * Shopify Style Checkout Multi Step.
	 */
	public function enqueue() {
		$handle = Fns::optimized_handle( 'rtsb-public' );

		wp_enqueue_script( 'rtsb-sticky-sidebar' );
		wp_localize_script(
			$handle,
			'rtsbShopifyCheckoutParams',
			[
				'stepError' => esc_html__( 'Some information seems to be missing or incorrect. Please check your details and try again.', 'shopbuilder-pro' ),
			]
		);
	}
	/**
	 * Shopify Style Checkout Multi Step.
	 */
	public function continue_button() {
		global $shopify_checkout_options;
		$steps = [
			'#billingAddress' => [
				'nextBtn' => esc_html__( 'Continue to billing', 'shopbuilder-pro' ),
				'prevBtn' => $shopify_checkout_options['return_btn_text_for_billing'] ?? esc_html__( 'Return to billing', 'shopbuilder-pro' ),
			],
		];
		if ( WC()->cart->needs_shipping_address() === true ) {
			$steps['#shippingAddress'] = [
				'nextBtn' => $shopify_checkout_options['continue_btn_text_for_shipping'] ?? esc_html__( 'Continue to shipping', 'shopbuilder-pro' ),
				'prevBtn' => $shopify_checkout_options['return_btn_text_for_shipping'] ?? esc_html__( 'Return to shipping', 'shopbuilder-pro' ),
			];
			$steps['#shippingMethod']  = [
				'nextBtn' => $shopify_checkout_options['continue_btn_text_for_shipping_method'] ?? esc_html__( 'Continue to shipping Method', 'shopbuilder-pro' ),
				'prevBtn' => $shopify_checkout_options['return_btn_text_for_shipping_method'] ?? esc_html__( 'Return to shipping Method', 'shopbuilder-pro' ),
			];
		}
		$steps['#makePayment'] = [
			'nextBtn' => $shopify_checkout_options['continue_btn_text_for_payment'] ?? esc_html__( 'Continue to payment', 'shopbuilder-pro' ),
			'prevBtn' => esc_html__( 'Return To payment', 'shopbuilder-pro' ),
		];
		Fns::load_template(
			'shopify-checkout/checkout-shopify-continue',
			[
				'steps'             => apply_filters( 'rtsb/shopify/checkout/steps', $steps ),
				'available_buttons' => [
					'next' => $shopify_checkout_options['shop_continue_btn'] ?? false,
					'prev' => $shopify_checkout_options['shop_return_btn'] ?? false,
				],
			],
			false,
			'',
			rtsbpro()->get_plugin_template_path()
		);
	}
	/**
	 * Shopify Style Checkout Multi Step.
	 */
	public function multi_step_menu() {
		global $shopify_checkout_options;
		if ( 'on' === ( $shopify_checkout_options['show_step_menu'] ?? 'off' ) ) {
			Fns::load_template(
				'shopify-checkout/checkout-multi-step-menu',
				[
					'steps' => [
						'show_cart'            => $shopify_checkout_options['show_cart_menu'] ?? false,
						'cart_text'            => $shopify_checkout_options['cart_text'] ?? false,
						'billing_text'         => $shopify_checkout_options['billing_text'] ?? false,
						'shipping_text'        => $shopify_checkout_options['shipping_text'] ?? false,
						'shipping_method_text' => $shopify_checkout_options['shipping_method_text'] ?? false,
						'payment_text'         => $shopify_checkout_options['payment_text'] ?? false,
					],
				],
				false,
				'',
				rtsbpro()->get_plugin_template_path()
			);
		}
	}
}
