<?php
/**
 * Smart Coupons Module Coupon Filters Class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Modules\SmartCoupons\Admin;

use RadiusTheme\SBPRO\Traits\SingletonTrait;
use RadiusTheme\SBPRO\Modules\SmartCoupons\SmartCouponsFns;

defined( 'ABSPATH' ) || exit();

/**
 * Smart Coupons Module Coupon Filters Class.
 */
class AdminFilters {
	/**
	 * Singleton Trait.
	 */
	use SingletonTrait;

	/**
	 * Class Constructor.
	 */
	private function __construct() {
		/**
		 * Actions.
		 */
		add_action( 'restrict_manage_posts', [ $this, 'add_custom_filters' ], 20 );

		/**
		 * Filters
		 */
	}

	/**
	 * Register custom taxonomy.
	 *
	 * @return void
	 */
	public function add_custom_filters() {
		global $typenow;

		if ( 'shop_coupon' !== $typenow ) {
			return;
		}

		$this
			->render_category_dropdown()
			->render_group_button();
	}

	/**
	 * Render category dropdown.
	 *
	 * @return AdminFilters
	 */
	private function render_category_dropdown() {
		global $wp_query;

		wc_product_dropdown_categories(
			[
				'taxonomy'           => 'rtsb_coupon_group',
				'name'               => 'rtsb_coupon_group',
				'option_select_text' => esc_html__( 'Filter by group', 'shopbuilder-pro' ),
				'show_option_none'   => __( 'Filter by group', 'shopbuilder-pro' ),
				'selected'           => $wp_query->query_vars['rtsb_coupon_group'] ?? '',
				'hide_empty'         => false,
			]
		);

		return $this;
	}

	/**
	 * Render group button.
	 *
	 * @return void
	 */
	private function render_group_button() {
		$tax_url = admin_url( 'edit-tags.php?taxonomy=rtsb_coupon_group&post_type=shop_coupon' );
		?>
		<div class="alignright">
			<?php
			if ( ! empty( SmartCouponsFns::get_settings_data()['enable_exporter'] ) ) {
				?>
				<button type="button" class="button" id="rtsb_export_coupons" name="rtsb_export_coupons" value="<?php echo esc_attr__( 'Export', 'shopbuilder-pro' ); ?>">
					<span class="loader"></span>
					<span class="dashicons dashicons-upload"></span><?php echo esc_html__( 'Export Coupons', 'shopbuilder-pro' ); ?>
				</button>
				<?php
			}
			?>
			<a class="button" id="rtsb-coupon-group-filter" href="<?php echo esc_url( $tax_url ); ?>">
				<span class="dashicons dashicons-category"></span>
				<span><?php echo esc_html__( 'Manage coupon groups', 'shopbuilder-pro' ); ?></span>
			</a>
		</div>
		<?php
		add_action( 'admin_footer', [ $this, 'enqueue_export_script' ] );
	}

	/**
	 * Enqueue export script.
	 *
	 * @return void
	 */
	public function enqueue_export_script() {
		$ajax_url = admin_url( 'admin-ajax.php' );

		if ( in_array( 'sitepress-multilingual-cms/sitepress.php', get_option( 'active_plugins', [] ), true ) ) {
			$ajax_url = admin_url( 'admin-ajax.php?lang=' . ICL_LANGUAGE_CODE );
		}

		$nonce_id   = rtsb()->nonceId;
		$nonce_text = rtsb()->nonceText;
		$nonce      = wp_create_nonce( $nonce_text );
		?>
		<script type="text/javascript">
			jQuery(document).ready(function($) {
				$('#rtsb_export_coupons').on('click', function(event) {
					event.preventDefault();

					// Collect the form data
					var formData = $('#posts-filter').serialize();

					// Perform the AJAX request
					$.ajax({
						url: <?php echo wp_json_encode( $ajax_url ); ?>,
						type: 'POST',
						data: {
							action: 'rtsb_export_coupons',
							form_data: formData,
							<?php echo wp_json_encode( $nonce_id ); ?>: <?php echo wp_json_encode( $nonce ); ?>
						},
						beforeSend: function() {
							$('#rtsb_export_coupons')
								.prop('disabled', true)
								.addClass('loading')
								.html('<span class="loader"></span><span class="dashicons dashicons-upload"></span>Exporting...');
						},
						success: function(response) {
							if (response.success) {
								if (response.data && response.data.download_url) {
									var $downloadLink = $('<a>')
										.attr('href', response.data.download_url)
										.attr('download', '');

									$('body').append($downloadLink);

									$downloadLink[0].click();
									$downloadLink.remove();
								}
							} else {
								alert(response.data.message || 'An error occurred during the export.');
							}
						},
						error: function(xhr, status, error) {
							alert('An error occurred: ' + error);
						},
						complete: function() {
							$('#rtsb_export_coupons')
								.prop('disabled', false)
								.removeClass('loading')
								.html(`<span class="loader"></span><span class="dashicons dashicons-upload"></span>Export Coupons`);
						}
					});
				});
			});
		</script>
		<?php
	}
}
