<?php
/**
 * Smart Coupons Admin Class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Modules\SmartCoupons;

use RadiusTheme\SBPRO\Traits\SingletonTrait;
use RadiusTheme\SBPRO\Modules\SmartCoupons\Admin\AdminPages;
use RadiusTheme\SBPRO\Modules\SmartCoupons\Admin\AdminColumns;
use RadiusTheme\SBPRO\Modules\SmartCoupons\Admin\AdminFilters;
use RadiusTheme\SBPRO\Modules\SmartCoupons\Admin\CouponFields;
use RadiusTheme\SBPRO\Modules\SmartCoupons\Admin\ExportCoupons;

defined( 'ABSPATH' ) || exit();

/**
 * Sticky add-to-cart Admin Class.
 */
class SmartCouponsAdmin {
	/**
	 * Singleton Trait.
	 */
	use SingletonTrait;

	/**
	 * Module Class Constructor.
	 */
	private function __construct() {
		AdminPages::instance();
		CouponFields::instance();
		AdminFilters::instance();
		AdminColumns::instance();
		ExportCoupons::instance();
	}
}
