<?php
/**
 * Main FilterHooks class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Modules\VariationSwatches;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SB\Modules\VariationSwatches\SwatchesFns;
use RadiusTheme\SBPRO\Traits\SingletonTrait;

defined( 'ABSPATH' ) || exit();

/**
 * Class ChowCase
 */
class ShowCase {
	/**
	 * Singleton Trait.
	 */
	use SingletonTrait;

	/**
	 * Constructor.
	 */
	private function __construct() {
		$this->shop_page_init();
	}

	/**
	 * Initialize swatches display on the shop page.
	 *
	 * @return void
	 */
	public function shop_page_init() {
		if ( 'on' !== SwatchesFns::get_options( 'enable_showcase_swatches' ) ) {
			return;
		}
		add_action( 'wp_ajax_nopriv_rtsb_add_variation_to_cart', [ $this, 'add_to_cart' ] );
		add_action( 'wp_ajax_rtsb_add_variation_to_cart', [ $this, 'add_to_cart' ] );
		$swatches_position = SwatchesFns::get_options( 'showcase_swatches_position' );
		switch ( $swatches_position ) {
			case 'after_add_to_cart':
				add_action( 'woocommerce_after_shop_loop_item', [ $this, 'showcase_variation_swatches' ], 10 );
				break;
			case 'before_add_to_cart':
				add_action( 'woocommerce_after_shop_loop_item', [ $this, 'showcase_variation_swatches' ], 8 );
				break;
		}
		// Some themes don't use 'woocommerce_after_shop_loop_item'.
		// Use this alternative action in woocommerce/content-product.php if needed.
		add_action( 'rtsb/vs/showcase/variation', [ $this, 'showcase_variation_swatches' ] );
	}
	/**
	 * @return void
	 */
	public function add_to_cart() {
		ob_start();
		$data              = wp_parse_args(
			$_POST, // phpcs:ignore WordPress.Security.NonceVerification.Missing
			[
				'product_id'   => 0,
				'quantity'     => 0,
				'variation_id' => 0,
				'variation'    => [],
			]
		);
		$product_id        = apply_filters( 'woocommerce_add_to_cart_product_id', absint( $data['product_id'] ) );
		$product           = wc_get_product( $product_id );
		$quantity          = empty( $data['quantity'] ) ? 1 : wc_stock_amount( $data['quantity'] );
		$passed_validation = apply_filters( 'woocommerce_add_to_cart_validation', true, $product_id, $quantity );
		$product_status    = get_post_status( $product_id );
		$variation_id      = absint( $data['variation_id'] );
		$variation         = $data['variation'];
		// If Not a variation.
		if (
			( 'variable' != $product->get_type() || empty( $variation_id ) ) ||
			! $passed_validation ||
			false === WC()->cart->add_to_cart( $product_id, $quantity, $variation_id, $variation ) ||
			'publish' !== $product_status
		) {
			// If there was an error adding to the cart, redirect to the product page to show any errors.
			$response = [
				'error'       => true,
				'product_url' => apply_filters( 'woocommerce_cart_redirect_after_error', get_permalink( $product_id ), $product_id ),
			];
			wp_send_json( $response );
		}
		do_action( 'woocommerce_ajax_added_to_cart', $product_id );
		if ( 'yes' === get_option( 'woocommerce_cart_redirect_after_add' ) ) {
			wc_add_to_cart_message( [ $product_id => $quantity ], true );
		}
		// Return fragments.
		\WC_AJAX::get_refreshed_fragments();
	}

	/**
	 * Render variation swatches in the archive/shop loop.
	 *
	 * @return void
	 */
	public function showcase_variation_swatches() {
		global $product;

		if ( ! is_object( $product ) || 'variable' !== $product->get_type() ) {
			return;
		}
		if ( 'on' !== SwatchesFns::get_options( 'enable_showcase_swatches' ) ) {
			return;
		}
		if ( ! $product->has_child() ) {
			return;
		}
		$product_id = $product->get_id();
		$attributes = $product->get_variation_attributes();
		if ( empty( $attributes ) || count( $attributes ) === 0 ) {
			return;
		}
		$available_variations = false;
		$default_attributes   = $product->get_default_attributes();
		$meta_data            = get_post_meta( $product_id, '_rtsb_vs', true );

		$data = compact(
			'attributes',
			'available_variations',
			'default_attributes',
			'product',
			'product_id',
			'meta_data'
		);
		Fns::load_template( 'variation-swatches/showcase-variation', $data, false, '', rtsbpro()->get_plugin_template_path() );
	}
}
