<?php
/**
 * Template variables:
 *
 * @var $key                   object
 */

use RadiusTheme\SB\Modules\VariationSwatches\SwatchesFns;
use RadiusTheme\SBPRO\Modules\VariationSwatches\Field;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$terms                      = get_terms(
	[
		'taxonomy'   => $key,
		'orderby'    => 'name',
		'hide_empty' => false,
	]
);
$attribute_type             = isset( $meta_data[ $key ]['type'] ) && $meta_data[ $key ]['type'] ? $meta_data[ $key ]['type'] : null;
$attribute_type             = SwatchesFns::get_valid_product_attribute_type_from_available_types( $attribute_type );
$global_attribute_type      = SwatchesFns::get_global_attribute_type( $key );
$available_attributes_types = SwatchesFns::get_available_attributes_types();
$type                       = $attribute_type ?: $global_attribute_type; // phpcs:ignore
?>
<div data-taxonomy="<?php echo esc_attr( $key ); ?>"
	 class="woocommerce_attribute rtsb-vs-attribute-box-wrapper rtsb_vs_visible_if_<?php echo esc_attr( $type ); ?> wc-metabox closed">
	<h3>
		<strong class="attribute_name"><?php echo esc_html( wc_attribute_label( $key ) ); ?></strong>
		<div class="rtsb-vs-term-handler">
			<?php
			woocommerce_wp_select(
				[
					'label'   => esc_html__( 'Attribute Type', 'shopbuilder-pro' ), // Text in Label.
					'value'   => isset( $meta_data[ $key ]['type'] ) ? esc_attr( $meta_data[ $key ]['type'] ) : '',
					'id'      => 'rtsb_vs_attribute_type_' . $key,
					'name'    => "rtsb_vs[{$key}][type]",
					'class'   => 'rtsb-vs-attribute-type',
					'options' => array_merge(
						[
							'' => esc_html__( 'Global', 'shopbuilder-pro' ),
						],
						$available_attributes_types,
						[ 'custom' => esc_html__( 'Custom', 'shopbuilder-pro' ) ]
					),
				]
			);
			?>
		</div>
	</h3>
	<div class="woocommerce_attribute_data wc-metabox-content rtsb-vs-metaboxes-wrapper hidden">
		<div class="rtsb-vs-attribute-term-panel-group rtsb-vs-metaboxes">
			<?php

			if ( ! empty( $values ) ) {
				foreach ( $values as $value ) {
					$termLabel = $value;
					if ( ! is_wp_error( $terms ) ) {
						foreach ( $terms as $term ) { // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
							if ( $term->slug !== $value ) {
								continue;
							}
							$termLabel = $term->name;
							break; // Stop loop once found.
						}
					}
					if ( 'custom' === $type && isset( $meta_data[ $key ]['data'][ $value ]['type'] ) ) {
						$term_type = $meta_data[ $key ]['data'][ $value ]['type'];
					} elseif ( ! $type ) {
						$term_type = current( array_keys( $available_attributes_types ) );
					} else {
						$term_type = $type;
					}
					$tooltip = isset( $meta_data[ $key ]['data'][ $value ]['tooltip'] ) ? $meta_data[ $key ]['data'][ $value ]['tooltip'] : '';
					?>
					<div class="rtsb-vs-attribute-term-panel rtsb-vs-attribute-term-box-wrapper rtsb_vs_visible_if_term_<?php echo esc_attr( $term_type ); ?> rtsb-vs-metabox closed">
						<h3>
							<div class="label"><?php echo esc_html( $termLabel ); ?></div>
							<div class="rtsb-vs-term-handler">
								<?php
								woocommerce_wp_select(
									[
										'label'   => esc_html__( 'Type', 'shopbuilder-pro' ),
										'value'   => $term_type,
										'id'      => 'rtsb_vs_term_' . $key . '_' . $value,
										'class'   => 'rtsb-vs-attribute-term-type',
										'name'    => "rtsb_vs[{$key}][data][{$value}][type]",
										'options' => $available_attributes_types,
									]
								);
								?>
							</div>
						</h3>
						<div class="rtsb-vs-term-data rtsb-vs-metabox-content hidden">
							<div class="rtsb-vs-metabox-content-wrap rtsb_vs_visible_if_tooltip_<?php echo esc_attr( $tooltip ); ?>">
								<?php
								$is_dual_color = isset( $meta_data[ $key ]['data'][ $value ]['is_dual_color'] ) && 'yes' === $meta_data[ $key ]['data'][ $value ]['is_dual_color'] ? 'yes' : 'no';
								$fields        = [
									[
										'label' => esc_html__( 'Image', 'shopbuilder-pro' ),
										'desc'  => esc_html__( 'Choose an Image', 'shopbuilder-pro' ),
										'id'    => 'rtsb_vs_term_' . $key . '_' . $value . '_image',
										'value' => isset( $meta_data[ $key ]['data'][ $value ]['image'] ) ? $meta_data[ $key ]['data'][ $value ]['image'] : '',
										'class' => 'rtsb-vs-attribute-term-field rtsb-vs-attribute-term-image',
										'name'  => "rtsb_vs[{$key}][data][{$value}][image]",
										'type'  => 'image',
									],
									[
										'label' => esc_html__( 'Color', 'shopbuilder-pro' ),
										'id'    => 'rtsb_vs_term_' . $key . '_' . $value . '_color',
										'value' => isset( $meta_data[ $key ]['data'][ $value ]['color'] ) ? $meta_data[ $key ]['data'][ $value ]['color'] : '',
										'class' => 'rtsb-vs-attribute-term-field rtsb-vs-attribute-term-color',
										'name'  => "rtsb_vs[{$key}][data][{$value}][color]",
										'type'  => 'color',
									],
									[
										'label'         => esc_html__( 'Dual Color', 'shopbuilder-pro' ),
										'trigger_label' => esc_html__( 'Enable', 'shopbuilder-pro' ),
										'class'         => 'rtsb-vs-attribute-term-field rtsb-vs-attribute-term-is-dual-color',
										'name'          => "rtsb_vs[{$key}][data][{$value}][is_dual_color]",
										'value'         => $is_dual_color,
										'id'            => 'rtsb_vs_term_' . $key . '_' . $value . '_is_dual_color',
										'type'          => 'checkbox',
									],
									[
										'label' => esc_html__( 'Secondary Color', 'shopbuilder-pro' ),
										'id'    => 'rtsb_vs_term_' . $key . '_' . $value . '_secondary_color',
										'value' => isset( $meta_data[ $key ]['data'][ $value ]['secondary_color'] ) ? $meta_data[ $key ]['data'][ $value ]['secondary_color'] : '',
										'class' => 'rtsb-vs-attribute-term-field rtsb-vs-attribute-term-secondary-color',
										'name'  => "rtsb_vs[{$key}][data][{$value}][secondary_color]",
										'type'  => 'color',
									],
									[
										'label'   => esc_html__( 'Show Tooltip', 'shopbuilder-pro' ),
										'id'      => 'rtsb_vs_term_' . $key . '_' . $value . '_tooltip',
										'type'    => 'select',
										'value'   => $tooltip,
										'class'   => 'rtsb-vs-attribute-term-field rtsb-vs-attribute-term-tooltip',
										'name'    => "rtsb_vs[{$key}][data][{$value}][tooltip]",
										'options' => [
											''      => esc_html__( 'Global', 'shopbuilder-pro' ),
											'text'  => esc_html__( 'Text', 'shopbuilder-pro' ),
											'image' => esc_html__( 'Image', 'shopbuilder-pro' ),
											'no'    => esc_html__( 'No', 'shopbuilder-pro' ),
										],
									],
									[
										'label' => esc_html__( 'Tooltip Text', 'shopbuilder-pro' ),
										'desc'  => esc_html__( 'By default tooltip text will be the term name.', 'shopbuilder-pro' ),
										'id'    => 'rtsb_vs_term_' . $key . '_' . $value . '_tooltip_text',
										'name'  => "rtsb_vs[{$key}][data][{$value}][tooltip_text]",
										'value' => isset( $meta_data[ $key ]['data'][ $value ]['tooltip_text'] ) ? $meta_data[ $key ]['data'][ $value ]['tooltip_text'] : '',
										'type'  => 'text',
										'class' => 'rtsb-vs-attribute-term-field rtsb-vs-attribute-term-tooltip-text',
									],
									[
										'label' => esc_html__( 'Tooltip Image', 'shopbuilder-pro' ), // <label>.
										'desc'  => esc_html__( 'Choose an image for tooltip.', 'shopbuilder-pro' ), // description.
										'id'    => 'rtsb_vs_term_' . $key . '_' . $value . '_tooltip_text',
										'name'  => "rtsb_vs[{$key}][data][{$value}][tooltip_image]",
										'value' => isset( $meta_data[ $key ]['data'][ $value ]['tooltip_image'] ) ? $meta_data[ $key ]['data'][ $value ]['tooltip_image'] : '',
										'type'  => 'image',
										'class' => 'rtsb-vs-attribute-term-field rtsb-vs-attribute-term-tooltip-image',
									],
								];
								Field::generate_fields( $fields );
								?>
							</div>
						</div>
					</div>
					<?php
				}
			}

			?>
		</div>
	</div>
</div>
