<?php
/**
 * Template variables:
 *
 * @var $product                   object
 */

global $post, $woocommerce, $product_object;

use RadiusTheme\SB\Modules\VariationSwatches\SwatchesFns;
use RadiusTheme\SBPRO\Modules\VariationSwatches\SwatchFnsPro;
use RadiusTheme\SBPRO\Modules\VariationSwatches\Field;


$product_type = $product->get_type();
if ( 'variable' !== $product_type ) {
	return;
}
$options    = SwatchesFns::get_options();
$attributes = $product->get_variation_attributes();
$meta_data  = get_post_meta( $product->get_id(), '_rtsb_vs', true );

$product_meta_fields = [
	[
		'label'   => esc_html__( 'Catalog mode single attribute', 'shopbuilder-pro' ),
		'id'      => 'rtsb-vs-showcase-single-attribute',
		'type'    => 'select',
		'value'   => $meta_data['showcase_single_attribute'] ?? '',
		'name'    => 'rtsb_vs[showcase_single_attribute]',
		'options' => array_merge(
			[
				'' => __( 'Global', 'shopbuilder-pro' ),
			],
			SwatchFnsPro::get_product_attributes_array( $attributes )
		),

	],
];


?>

<?php if ( ! empty( $product_meta_fields ) ) : ?>
	<div class="toolbar toolbar-top">
		<?php Field::generate_fields( $product_meta_fields ); ?>
	</div>
	<hr style="margin: 0; "/>
<?php endif; ?>
<?php if ( ( ! empty( $attributes ) ) && ( count( $attributes ) > 0 ) ) { ?>
	<div class="rtsb-vs-product-attributes wc-metaboxes">
		<?php
		foreach ( $attributes as $key => $values ) {
			include RTSBPRO_PATH . '/app/Modules/VariationSwatches/view/product-attribute.php';
		}
		?>
	</div>
	<div class="toolbar">
		<button type="button" class="button-primary rtsb-vs-save-attributes">
			<?php esc_html_e( 'Save product switches', 'shopbuilder-pro' ); ?>
		</button>
		<button type="button" class="button rtsb-vs-reset-attributes">
			<?php esc_html_e( 'Reset to default', 'shopbuilder-pro' ); ?>
		</button>
	</div>

<?php } ?>
