<?php
/**
 * @wordpress-plugin
 * Plugin Name:                ShopBuilder Pro – Elementor WooCommerce Builder Addons
 * Plugin URI:                 https://shopbuilderwp.com/
 * Description:                This is the Pro version of ShopBuilder - Elementor WooCommerce Builder Addons.
 * Version:                    2.0.1
 * Author:                     RadiusTheme
 * Author URI:                 https://radiustheme.com
 * Text Domain:                shopbuilder-pro
 * Domain Path:                /languages
 * Requires at least:          6.0
 * Tested up to:               6.8
 * WC requires at least:       3.2
 * WC tested up to:            10.0
 * Elementor tested up to:     3.30
 * Elementor Pro tested up to: 3.30
 *
 * @package RadiusTheme\SBPRO
 */

use RadiusTheme\SBPRO\ShopBuilderPro;
use RadiusTheme\SBPRO\Helpers\Installation;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

define( 'RTSBPRO_VERSION', '2.0.1' );
define( 'RTSBPRO_FILE', __FILE__ );
define( 'RTSBPRO_PATH', plugin_dir_path( __FILE__ ) );
define( 'RTSBPRO_ACTIVE_FILE_NAME', plugin_basename( __FILE__ ) );
define( 'RTSBPRO_URL', plugins_url( '', RTSBPRO_FILE ) );

require_once RTSBPRO_PATH . 'vendor/autoload.php';

/**
 * Function for external access.
 *
 * @return ShopBuilderPro
 */
function rtsbpro() {
	// Use a static variable to store the cached data for the current request.
	static $cached_instance;
	if ( null !== $cached_instance ) {
		return $cached_instance;
	}
	$cached_instance = ShopBuilderPro::instance();

	return $cached_instance;
}

add_action( 'plugins_loaded', 'rtsbpro', 20 );

// Register Plugin Active Hook.
register_activation_hook( RTSBPRO_FILE, [ Installation::class, 'activate' ] );
// Register Plugin Deactivate Hook.
register_deactivation_hook( RTSBPRO_FILE, [ Installation::class, 'deactivation' ] );
