<?php
/**
 * Template: Product Add-Ons Field Type Image Upload.
 *
 * @package RadiusTheme\SBPRO
 */

/**
 * Template variables:
 *
 * @var $field_id       string
 * @var $label          string
 * @var $description    string
 * @var $required       string
 * @var $tooltip        string
 * @var $price          string
 * @var $field_value    string|array
 * @var $field_required string
 */

use RadiusTheme\SBPRO\Modules\AddOns\AddOnsFns;

// Do not allow direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

$allowed_extensions = AddOnsFns::get_add_ons_settings_data()['allowed_extensions'];
$allowed_extensions = implode(
	',',
	array_map(
		function ( $ext ) {
			return '.' . ltrim( $ext, '.' );
		},
		$allowed_extensions
	)
);
?>

<div class="rtsb-addon-field-content rtsb-addon-field-image">
	<div class="rtsb-upload-container">
		<input
			type="file"
			id="<?php echo esc_attr( $field_id ); ?>"
			class="rtsb-addon-file-input"
			accept="<?php echo esc_attr( $allowed_extensions ); ?>"
			data-price="<?php echo esc_attr( $price ); ?>"
			name="<?php echo esc_attr( $field_id ); ?>-file"
			hidden
		/>
		<input type="hidden" class="rtsb-addon-image-info" id="<?php echo esc_attr( $field_id ); ?>-image" name="<?php echo esc_attr( $field_id ); ?>" value="">

		<div class="rtsb-drag-drop-area">
			<div class="drag-drop-wrapper">
				<p><?php echo esc_html__( 'Drop Your Image Here or', 'shopbuilder-pro' ); ?></p>
				<button type="button" class="rtsb-choose-file" data-field-id="<?php echo esc_attr( $field_id ); ?>">
					<svg class="no-fill" fill="none" height="14" viewBox="0 0 13 14" width="13" xmlns="http://www.w3.org/2000/svg"><path d="m5.38051 7.60401c.24062.34678.54761.63372.90015.84136.35254.20763.74238.3311 1.14308.36204.4007.03093.80288-.03139 1.17927-.18275.37639-.15135.71819-.3882 1.0022-.69448l1.68089-1.81204c.5103-.56959.7927-1.33247.7863-2.12432-.0063-.79185-.301-1.54932-.8204-2.10926-.5194-.55995-1.2221-.87756-1.95664-.88445-.73455-.006877-1.44222.29753-1.9706.84766l-.96372 1.03286m1.26069 3.51536c-.24063-.34678-.54762-.63372-.90016-.84136-.35254-.20763-.74238-.3311-1.14308-.36204-.4007-.03093-.80288.03139-1.17927.18275-.37639.15135-.71818.3882-1.0022.69448l-1.68091 1.81204c-.51032.56959-.7927 1.33247-.786317 2.12434.006383.7918.301017 1.5493.820447 2.1092.51942.56 1.22208.8776 1.95663.8845s1.44222-.2975 1.9706-.8477l.95812-1.0328" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.28571"/></svg>
					<?php esc_html_e( 'Choose Image', 'shopbuilder-pro' ); ?>
				</button>
			</div>
			<div id="rtsb_upload_preview_<?php echo esc_attr( $field_id ); ?>" class="rtsb-hidden">
				<div class="rtsb-upload-item">
					<img id="rtsb_uploaded_image_<?php echo esc_attr( $field_id ); ?>" src="<?php echo ! empty( $field_value ) ? esc_url( $field_value ) : ''; ?>" alt="<?php esc_attr_e( 'Uploaded Image', 'shopbuilder-pro' ); ?>" />
					<div class="rtsb-upload-info">
						<div class="upload-info-inner">
							<span id="rtsb_file_name_<?php echo esc_attr( $field_id ); ?>"></span>
							<div class="size-info">
								<span id="rtsb_file_size_<?php echo esc_attr( $field_id ); ?>"></span>
							</div>
						</div>
						<div class="rtsb-progress-bar">
							<div id="rtsb_progress_fill_<?php echo esc_attr( $field_id ); ?>" style="width: 0%;"></div>
						</div>
					</div>
					<button type="button" class="rtsb-remove-file rtsb-hidden" data-field-id="<?php echo esc_attr( $field_id ); ?>">
						<svg class="no-fill" fill="none" height="20" viewBox="0 0 20 20" width="20" xmlns="http://www.w3.org/2000/svg"><rect fill="#ff3f3f" height="20" rx="10" width="20"/><path d="m6 7.6h.88889m0 0h7.11111m-7.11111 0v5.6c0 .2122.09365.4157.26035.5657s.39279.2343.62854.2343h4.44442c.2358 0 .4619-.0843.6286-.2343s.2603-.3535.2603-.5657v-5.6m-4.88888 0v-.8c0-.21217.09365-.41566.26035-.56569.1667-.15002.39279-.23431.62854-.23431h1.77779c.2357 0 .4618.08429.6285.23431.1667.15003.2604.35352.2604.56569v.8" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width=".8"/></svg>
					</button>
				</div>
			</div>
		</div>
	</div>
</div>
