<?php
/**
 * Template: Product Add-Ons Field Type Switch.
 *
 * @package RadiusTheme\SBPRO
 */

/**
 * Template variables:
 *
 * @var $field_id            string
 * @var $label               string
 * @var $description         string
 * @var $required            string
 * @var $tooltip             string
 * @var $placeholder         string
 * @var $multiple            string
 * @var $price               string
 * @var $options             array
 * @var $price_display       string
 * @var $field_value         string|array
 * @var $field_required      string
 */

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Modules\AddOns\AddOnsFns;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

// phpcs:ignore WordPress.Security.NonceVerification.Recommended
$is_form_submitted = AddOnsFns::key_exists( '/rtsb_addon_field/', $_REQUEST );
?>

<div class="rtsb-addon-field-content rtsb-addon-field-switch">
	<div class="rtsb-checkbox-group switch<?php echo esc_attr( $field_required . ( 'on' === $multiple ? ' has-multi-select' : '' ) ); ?>" data-multi-select="<?php echo esc_attr( $multiple ); ?>">
		<?php
		if ( ! empty( $options ) && is_array( $options ) ) {
			foreach ( $options as $option ) {
				$options_data = AddOnsFns::field_options_data( $option, $field_value );

				list(
					$option_id,
					$option_name,
					$option_price,
					$default_checked,
				) = $options_data;

				$option_id            = $field_id . '_' . $option_id;
				$input_name           = 'on' === $multiple ? $option_id . '[]' : $field_id;
				$option_price_display = $option_price > 0 ? '(+ ' . wc_price( $option_price ) . ')' : '';

				if ( 'on' === $multiple ) {
					$option_value = ! empty( $_REQUEST[ $option_id ] ) ? array_map( 'sanitize_text_field', wp_unslash( $_REQUEST[ $option_id ] ) ) : []; // phpcs:ignore WordPress.Security.NonceVerification.Recommended
					$is_checked   = in_array( $option_name, $option_value, true );
				} else {
					$option_value = $option_name;
					$is_checked   = $option_name === $field_value;
				}
				?>
				<div id="<?php echo esc_attr( $option_id . '_wrap' ); ?>" class="rtsb-checkbox-field">
					<label>
						<span class="checkbox-content">
							<span class="switch-field">
								<input
										type="checkbox"
										id="<?php echo esc_attr( $option_id ); ?>"
										name="<?php echo esc_attr( $input_name ); ?>"
										value="<?php echo esc_attr( $option_name ); ?>"
										data-price="<?php echo esc_attr( $option_price ); ?>"
									<?php checked( $is_form_submitted ? $is_checked : $default_checked ); ?>
								/>
								<span class="slider"></span>
							</span>
							<span class="rtsb-option-label">
								<?php
								echo esc_html( $option_name );
								?>
								<span class="rtsb-addon-price">
									<?php
									Fns::print_html( $option_price_display );
									?>
								</span>
							</span>
						</span>
					</label>
				</div>
				<?php
			}
		} else {
			?>
			<p><?php esc_html_e( 'No options available.', 'shopbuilder-pro' ); ?></p>
			<?php
		}
		?>
	</div>
</div>
