<?php
/**
 * Template: Product Add-Ons Field Type Text.
 *
 * @package RadiusTheme\SBPRO
 */

/**
 * Template variables:
 *
 * @var $field_id            string
 * @var $label               string
 * @var $description         string
 * @var $required            string
 * @var $tooltip             string
 * @var $placeholder         string
 * @var $price               string
 * @var $field_value         string|array
 * @var $field_required      string
 */

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}
?>

<div class="rtsb-addon-field-content rtsb-addon-field-text">
	<input
		type="text"
		id="<?php echo esc_attr( $field_id ); ?>"
		name="<?php echo esc_attr( $field_id ); ?>"
		value="<?php echo esc_attr( $field_value ); ?>"
		placeholder="<?php echo esc_attr( $placeholder ); ?>"
		data-price="<?php echo esc_attr( $price ); ?>"
		<?php echo esc_attr( $field_required ); ?>
	/>
</div>
