<?php
/**
 * Template variables:
 *
 * @var $class string Endpoint data
 * @var $currency string Endpoint data
 * @var $url string Endpoint data
 * @var $path string Endpoint data
 * @var $flag_url string Flag Url
 * @var $currency_info array Endpoint data
 * @var $show_flag bool Flag Show Or Hide
 * @var $show_currency_text bool Currency Show oh hide
 */

?>
<a class="<?php echo esc_attr( $class ); ?>" data-currency="<?php echo esc_attr( $currency ); ?>" href="<?php echo esc_url( $url ); ?>">
	<?php if ( $show_flag && file_exists( $path ) ) { ?>
		<span class="flag-wrapper">
			<img width="25" height="17" src="<?php echo esc_url( $flag_url ); ?>" alt="<?php echo esc_attr( $currency ); ?>">
		</span>
	<?php } ?>
	<?php if ( $show_currency_text ) { ?>
		<span  class="currency-wrapper"> <?php echo esc_html( $currency_info['title'] ?? '' ); ?> </span>
	<?php } ?>

</a>