<?php
/**
 * Template variables:
 *
 * @var $tax_type          string        Taxonomy type.
 * @var $attr_type         string        Attribute type.
 * @var $input             string        Input type.
 * @var $title             array         Filter title.
 * @var $multiple          Boolean       Multiple selection.
 * @var $relation          array         Filter relation.
 * @var $preset            string        Filter layout.
 * @var $template          string        Filter template.
 * @var $raw_settings      array         Widgets/Addons Settings
 * @var $repeater_settings array         Repeater Settings
 */

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Helpers\FnsPro;
use RadiusTheme\SBPRO\Elementor\Render\RenderPro;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

$tax_type         = FnsPro::get_tax_type( $tax_type, $attr_type );
$sale_options     = [
	'onsale'  => ! empty( $repeater_settings['onsale_title'] ) ? esc_html( $repeater_settings['onsale_title'] ) : esc_html__( 'On Sale Products', 'shopbuilder-pro' ),
	'regular' => ! empty( $repeater_settings['regular_title'] ) ? esc_html( $repeater_settings['regular_title'] ) : esc_html__( 'Regular Products', 'shopbuilder-pro' ),
];
$show_input_icon  = ! empty( $repeater_settings['show_input'] ) ? 'has-input-icons' : 'no-input-icons';
$columns          = ! empty( $repeater_settings['filter_display'] ) ? ' col-' . $repeater_settings['filter_display'] : ' col-default';
$additional_items = ! empty( $raw_settings['more_less_btn'] );
$additional_count = ! empty( $raw_settings['more_less_items']['size'] ) ? $raw_settings['more_less_items']['size'] : 1000000;
$tax_data         = FnsPro::get_products( $tax_type );
$is_attribute     = strpos( $tax_type, 'pa_' ) !== false;

if ( is_wp_error( $tax_data ) && 'sale_filter' !== $tax_type ) {
	Fns::print_html( RenderPro::error_message( $title, 'rtsb-categories' ) );

	return;
}

if ( $is_attribute && empty( FnsPro::get_attribute_terms( $tax_type ) ) ) {
	return;
}

$data = [
	'taxonomy'           => $is_attribute & ! $repeater_settings['show_empty'] ? FnsPro::get_attribute_terms( $tax_type ) : $tax_data,
	'is_attribute'       => $is_attribute,
	'exclude_categories' => $repeater_settings['exclude_terms'],
	'show_empty_terms'   => $repeater_settings['show_empty'],
	'show_child'         => ! empty( $repeater_settings['include_child_cats'] ),
	'additional_items'   => $additional_items ? $additional_count : 1000000,
	'count_display'      => ! empty( $raw_settings['count_display'] ) ? $raw_settings['count_display'] : 'none',
];

$ajax_data       = [
	'taxonomy' => $tax_type,
	'input'    => $input,
	'multiple' => $multiple,
	'relation' => $relation,
	'tax_data' => FnsPro::get_ajax_tax_data( $tax_data ),
];
$additional_args = [
	'total_count'      => 'sale_filter' === $tax_type ? 2 : count( $is_attribute ? FnsPro::get_attribute_terms( $tax_type ) : $tax_data ),
	'additional_count' => $additional_count,
	'tax_data'         => $tax_data,
];
?>

<div class="rtsb-product-filters rtsb-categories <?php echo 'sale_filter' === $tax_type ? 'rtsb-sale-filter' : ''; ?>">
	<?php
	/**
	 * Filter title.
	 */
	Fns::print_html( FnsPro::get_filter_title( $title ) );

	/**
	 * Filter content.
	 */
	echo '<div class="filter-content ' . esc_attr( $show_input_icon ) . esc_attr( $columns ) . '">';

	if ( ! empty( $tax_data ) && ! is_wp_error( $tax_data ) && 'sale_filter' !== $tax_type ) {
		Fns::print_html( FnsPro::get_product_filter_list_html( $data, $input, $ajax_data ), true );
	} else {
		if ( 'sale_filter' === $tax_type ) {
			Fns::print_html( FnsPro::get_filter_html( $tax_type, $sale_options, $ajax_data ), true );
		} else {
			echo '<p class="no-filter">' . esc_html__( 'Nothing found.', 'shopbuilder-pro' ) . '</p>';
		}
	}

	if ( 'sale_filter' !== $tax_type ) {
		FnsPro::get_more_less_button( $repeater_settings['filter_items'], $raw_settings, $additional_args );
	}

	echo '</div>';
	?>
</div>
