<?php
/**
 * Template variables:
 *
 * @var $tax_type          string        Taxonomy type.
 * @var $attr_type         string        Attribute type.
 * @var $input             string        Input type.
 * @var $title             array         Filter title.
 * @var $multiple          Boolean       Multiple selection.
 * @var $preset            string        Filter layout.
 * @var $template          string        Filter template.
 * @var $raw_settings      array         Widgets/Addons Settings
 * @var $repeater_settings array         Repeater Settings
 */

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Helpers\FnsPro;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}
?>

<div class="rtsb-product-filters rtsb-price">
	<?php
	$ajax_data   = [
		'taxonomy' => $tax_type,
		'input'    => $input,
		'multiple' => false,
	];
	$price_label = $repeater_settings['price_label'];

	/**
	 * Filter title.
	 */
	Fns::print_html( FnsPro::get_filter_title( $title ) );

	// $step   = max( apply_filters( 'woocommerce_price_filter_widget_step', 10 ), 1 );
	$step   = 1;
	$prices = FnsPro::get_filtered_price();

	$min_price = ! empty( $prices['min'] ) ? $prices['min'] : 0;
	$max_price = ! empty( $prices['max'] ) ? $prices['max'] : 1000;

	$min_price = apply_filters( 'woocommerce_price_filter_widget_min_amount', floor( $min_price / $step ) * $step );
	$max_price = apply_filters( 'woocommerce_price_filter_widget_max_amount', ceil( $max_price / $step ) * $step );

	$position          = apply_filters( 'rtsb/elementor/filter/price_format', 'left' );
	$current_min_price = isset( $_GET['min_price'] ) ? floor( floatval( wp_unslash( $_GET['min_price'] ) ) / $step ) * $step : $min_price;
	$current_max_price = isset( $_GET['max_price'] ) ? ceil( floatval( wp_unslash( $_GET['max_price'] ) ) / $step ) * $step : $max_price;
	$product_price     = FnsPro::get_product_min_max_prices();
	?>

	<div class="filter-content">
		<ul class="product-filters" data-rtsb-filter='<?php echo esc_js( wp_json_encode( $ajax_data ) ); ?>'>
			<li class="rtsb-term-item">
				<div class="rtsb-filter-group">
					<div class="rtsb-price-slider rtsb-price-range"></div>
					<div class="filter-price" data-steps="<?php echo absint( $step ); ?>" data-tooltip-direction="bottom">
						<div class="price-label">
							<span class="price-text"><?php echo esc_html( $price_label ); ?></span>
							<div class="price-result" data-symbol="<?php echo esc_attr( get_woocommerce_currency_symbol() ); ?>" data-position="<?php echo esc_attr( $position ); ?>">
								<span class="from"></span>
								<span class="separator"> — </span>
								<span class="to"></span>
							</div>
						</div>
						<button class="price-filter-reset tipsy" data-min="<?php echo absint( $product_price['min_price'] ); ?>" data-max="<?php echo absint( $product_price['max_price'] ); ?>" title="<?php echo esc_attr( 'Reset Price' ); ?>" rel="nofollow"></button>
						<div class="price-inputs">
							<label>
								<input class="filter-price-field js-price-down" type="text" data-min="<?php echo absint( $min_price ); ?>" value="<?php echo absint( $current_min_price ); ?>"/>
							</label>
							<label>
								<input class="filter-price-field js-price-up" type="text" data-max="<?php echo absint( $max_price ); ?>" value="<?php echo absint( $current_max_price ); ?>"/>
							</label>
						</div>
					</div>
				</div>
			</li>
		</ul>
	</div>
</div>
