<?php
/**
 * Template variables:
 *
 * @var $filters            array      Filters.
 * @var $collapse_type      string     Collapse type.
 * @var $collapse_mobile    string     Collapse in mobile.
 * @var $additional_opt     string     Additional options.
 * @var $scroll_mode        string     Scroll mode.
 * @var $reset_mode         string     Reset mode.
 * @var $scroll_top         string     Scroll top.
 * @var $additional_attr    string     Additional attributes.
 * @var $scroll_attr        string     Scroll attributes.
 * @var $reset              boolean    Reset.
 * @var $ajax_class         string     Ajax class.
 * @var $reset_text         string     Reset text.
 * @var $settings           array      Settings array.
 */

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Helpers\FnsPro;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

$wrapper_class  = $ajax_class . $collapse_mobile . $collapse_type . $additional_opt . $scroll_mode . $reset_mode . $scroll_top;
$accordion_mode = ! empty( $settings['collapse_open_mode'] ) ? ' expand-' . $settings['collapse_open_mode'] : ' expand-one';
$wrapper_class .= $accordion_mode;
?>

<div class="rtsb-archive-filters-wrapper vertical-layout<?php echo esc_attr( $wrapper_class ); ?>"<?php Fns::print_html( $additional_attr . $scroll_attr ); ?>>
	<?php
	/**
	 * Before archive filter items hook.
	 *
	 * @hooked RadiusTheme\SBPRO\Elementor\Render\RenderPro::filter_header 10
	 * @hooked RadiusTheme\SBPRO\Elementor\Render\RenderPro::filter_search 15
	 */
	do_action( 'rtsb/before/archive/filter/items', $settings );

	if ( ! empty( $filters ) && is_array( $filters ) ) {
		// phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
		foreach ( $filters as $name => $type ) {
			$arg['attr_type']         = '';
			$arg['tax_type']          = $type['filter_items'];
			$arg['title']             = [
				'title'         => $type['filter_title'],
				'show_icon'     => ! empty( $type['show_icon'] ),
				'icon'          => ! empty( $type['title_icon'] ) ? $type['title_icon'] : [],
				'icon_position' => ! empty( $settings['title_icon_alignment'] ) ? $settings['title_icon_alignment'] : 'left',
				'collapse'      => $settings['collapse_mode'],
				'preset'        => ! empty( $settings['title_icon_preset'] ) ? $settings['title_icon_preset'] : 'plus',
			];
			$arg['multiple']          = ! empty( $type['multiple'] );
			$arg['relation']          = $type['relation'];
			$arg['template']          = $type['template'];
			$arg['input']             = $type['input_type'];
			$arg['preset']            = $settings['layout'];
			$arg['reset']             = $reset;
			$arg['raw_settings']      = $settings;
			$arg['repeater_settings'] = $settings['filter_types'][ $name ];

			if ( 'product_attr' === $type['filter_items'] ) {
				$arg['attr_type'] = $type['filter_attr'];
			}

			if ( 'rating_filter' === $type['filter_items'] ) {
				$arg['rating_icon'] = $settings['filter_types'][ $name ]['rating_icon'];
				$arg['input']       = 'rating';
			}

			Fns::print_html( Fns::load_template( $type['template'], $arg, true, '', rtsbpro()->get_plugin_template_path() ), true );
		}
	} else {
		echo '<p>' . esc_html__( 'Please select a filter.', 'shopbuilder-pro' ) . '</p>';
	}

	Fns::print_html( FnsPro::get_filter_reset_button( $reset_text, $settings ), true );

	/**
	 * After archive filter items hook.
	 */
	do_action( 'rtsb/after/archive/filter/items', $settings );
	?>
</div>
