<?php
/**
 * Template: Category Layout 3.
 *
 * @package RadiusTheme\SB
 */

/**
 * Template variables:
 *
 * @var $grid                    string
 * @var $class                   string
 * @var $p_id                    int
 * @var $product_count           int
 * @var $sale_count              int
 * @var $image_link              bool
 * @var $cat_link                string
 * @var $img_html                string
 * @var $items                   array
 * @var $title_tag               string
 * @var $excerpt_limit           string
 * @var $excerpt                 string
 * @var $title_class             string
 * @var $title_link              bool
 * @var $target                  string
 * @var $title                   string
 * @var $count                   string
 * @var $count_position          string
 * @var $p_sale                  string
 * @var $badge_class             string
 * @var $excerpt_position        string
 * @var $excerpt_class           string
 * @var $count_text              string
 * @var $raw_settings            array
 */

use RadiusTheme\SB\Helpers\Fns;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

$show_count      = $raw_settings['show_count'];
$show_sale_count = $raw_settings['show_sale_items_count'];
$count_class     = $show_count || $show_sale_count ? ' has-count' : ' no-count';
?>

<div class="<?php echo esc_attr( $grid ) . ' ' . esc_attr( $class ); ?>">
	<div class="category-wrapper<?php echo esc_attr( $count_class ); ?>">
		<div class="rtsb-product-img">
			<?php
			/**
			 * Category Image.
			 */
			if ( $image_link ) {
				$aria_label = esc_attr(
				/* translators: Product Category Name */
					sprintf( __( 'Image link for Category: %s', 'shopbuilder-pro' ), $title )
				);
				?>
				<figure>
					<a href="<?php echo esc_url( $cat_link ); ?>" target="<?php echo esc_attr( $target ); ?>" class="rtsb-img-link" aria-label="<?php echo esc_attr( $aria_label ); ?>">
						<?php
						Fns::get_product_image( $img_html );
						?>
					</a>
				</figure>
				<?php
			} else {
				echo '<figure class="rtsb-img-link">';
				Fns::get_product_image( $img_html );
				echo '</figure>';
			}

			?>
	</div><!-- .rtsb-product-img -->
	<div class="rtsb-category-content">
		<div class="rtsb-content-wrapper">
			<?php
			/**
			 * Category Title.
			 */
			if ( in_array( 'title', $items, true ) ) {
				?>
			<<?php Fns::print_validated_html_tag( $title_tag ); ?> class="<?php echo esc_attr( $title_class ); ?>">
				<?php
				if ( $title_link ) {
					?>
				<a href="<?php echo esc_url( $cat_link ); ?>" target="<?php echo esc_attr( $target ); ?>"><?php Fns::print_html( $title ); ?></a>
					<?php
				} else {
					Fns::print_html( $title );
				}
				?>
		</<?php Fns::print_validated_html_tag( $title_tag ); ?>>
				<?php
			}
			/**
			 * Category Short Description.
			 */
			if ( in_array( 'excerpt', $items, true ) && $excerpt ) {
				?>
			<div class="category-description rtsb-text-limit limit-<?php echo esc_attr( $excerpt_limit ); ?>">
				<?php
				Fns::print_html( $excerpt );
				?>
			</div>
				<?php
			}
			?>
			<div class="category-count-wrapper">
			<?php
			if ( $product_count > 0 && $show_count ) {
				?>
				<div class="rtsb-total-products product-count">
					<?php
						Fns::print_html( $count );
					?>
				</div>
				<?php
			}
			?>
		</div>
		</div>
		<div class="rtsb-link-icon">
			<a href="<?php echo esc_url( $cat_link ); ?>" target="<?php echo esc_attr( $target ); ?>">
				<svg width="20px" height="20px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path fill-rule="evenodd" clip-rule="evenodd" d="M12.2929 4.29289C12.6834 3.90237 13.3166 3.90237 13.7071 4.29289L20.7071 11.2929C21.0976 11.6834 21.0976 12.3166 20.7071 12.7071L13.7071 19.7071C13.3166 20.0976 12.6834 20.0976 12.2929 19.7071C11.9024 19.3166 11.9024 18.6834 12.2929 18.2929L17.5858 13H4C3.44772 13 3 12.5523 3 12C3 11.4477 3.44772 11 4 11H17.5858L12.2929 5.70711C11.9024 5.31658 11.9024 4.68342 12.2929 4.29289Z" fill="#000000"/>
				</svg>
			</a>
		</div>
	</div>
</div><!-- .category-wrapper -->
</div><!-- .rtsb-category-grid -->
