<?php
/**
 * Template: Hero Slider Layout 1
 *
 * @package RadiusTheme\SBPRO
 */

/**
 * Template variables:
 *
 * @var $id                         string
 * @var $repeater_id                string
 * @var $settings                   array
 * @var $sliders                    array
 * @var $slider                     array
 * @var $render                     object
 * @var $wrapper_classes            string
 * @var $slider_image               string
 * @var $slider_subtitle            string
 * @var $slider_title               string
 * @var $slider_title2              string
 * @var $slider_title_tag           string
 * @var $slider_content             string
 * @var $btn_link                   string
 * @var $btn_text                   string
 * @var $parallax_effect            boolean
 * @var $parallax_animation         string
 * @var $image_animation_duration   string
 * @var $animation_duration         string
 * @var $subtitle_ani_delay         string
 * @var $title_ani_delay            string
 * @var $title2_ani_delay           string
 * @var $image_animation_duration   string
 * @var $image_ani_delay            string
 * @var $content_ani_delay          string
 * @var $button_ani_delay           string
 * @var $slider_img_type            string
 * @var $slider_image_id            integer
 * @var $instance                   object
 * @var $display_subtitle           boolean
 * @var $display_title              boolean
 * @var $display_title2             boolean
 * @var $display_content            boolean
 * @var $display_button             boolean
 * @var $display_button_icon        boolean
 */

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Elementor\Helpers\AddonHelpersPro;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

$wrapper_attributes = [
	'class' => $wrapper_classes,
];

?>
<div class="<?php echo esc_attr( $wrapper_classes . ' ' . 'elementor-repeater-item-' . $repeater_id ); ?>">
	<div class="rtsb-hero-slider-item">
		<?php
		if ( $parallax_effect ) {
			?>
			<div class="rtsb-img-container <?php echo esc_attr( $slider_img_type ); ?>">
				<div class="rtsb-parallax-slider-image"
					<?php
					echo ( ! empty( $slider['slider_bg_foreground_img'] ) && 'foreground' === $slider_img_type )
						? 'data-bg-image="' . esc_attr( esc_url( $slider['slider_bg_foreground_img']['url'] ) ) . '"'
						: '';
					?>
				>
				</div>
			</div>
		<?php } ?>
		<div class="rtsb-slider-container">
			<div class="rtsb-slider-content-wrap">
				<div class="rtsb-slider-content">
					<?php
					if ( $display_subtitle && $slider_subtitle ) {
						?>
						<div class="rtsb-slider-subtitle"
							 data-swiper-animation="<?php echo esc_attr( $parallax_animation ); ?>"
							 data-duration="<?php echo esc_attr( $animation_duration ); ?>"
							 data-delay="<?php echo esc_attr( $subtitle_ani_delay ); ?>"
						>
							<?php Fns::print_html( $slider_subtitle ); ?>
						</div>
					<?php } ?>
					<?php
					if ( $display_title && $slider_title ) {
						?>
						<<?php Fns::print_validated_html_tag( $slider_title_tag ); ?>
							data-swiper-animation="<?php echo esc_attr( $parallax_animation ); ?>"
							data-duration="<?php echo esc_attr( $animation_duration ); ?>"
							data-delay="<?php echo esc_attr( $title_ani_delay ); ?>"
							class="rtsb-slider-title rtsb-tag">
							<?php Fns::print_html( $slider_title ); ?>
						</<?php Fns::print_validated_html_tag( $slider_title_tag ); ?>>
						<?php
					}
					?>
					<?php
					if ( $display_title2 && $slider_title2 ) {
						?>
						<div class="rtsb-slider-title2"
							 data-swiper-animation="<?php echo esc_attr( $parallax_animation ); ?>"
							 data-duration="<?php echo esc_attr( $animation_duration ); ?>"
							 data-delay="<?php echo esc_attr( $title2_ani_delay ); ?>"
						>
							<?php Fns::print_html( $slider_title2 ); ?>
						</div>
						<?php
					}
					?>

					<?php if ( $display_content && $slider_content ) { ?>
						<div class="rtsb-slider-des"
							 data-swiper-animation="<?php echo esc_attr( $parallax_animation ); ?>"
							 data-duration="<?php echo esc_attr( $animation_duration ); ?>"
							 data-delay="<?php echo esc_attr( $content_ani_delay ); ?>"
						>
							<?php Fns::print_html( $slider_content ); ?>
						</div>
					<?php } ?>
					<?php
					if ( $display_button ) {
						?>
						<div class="rtsb-slider-button"
							 data-swiper-animation="<?php echo esc_attr( $parallax_animation ); ?>"
							 data-duration="<?php echo esc_attr( $animation_duration ); ?>"
							 data-delay="<?php echo esc_attr( $button_ani_delay ); ?>"
						>
							<a <?php Fns::print_html( $btn_link ); ?>>
								<?php if ( $btn_text ) { ?>
									<span class="btn-text">
											<?php Fns::print_html( $btn_text ); ?>
										</span>
								<?php } ?>
								<?php
								if ( $display_button_icon && ! empty( $slider['btn_icon']['value'] ) ) {
									Fns::print_html( Fns::icons_manager( $slider['btn_icon'] ) );
								}
								?>
							</a>
						</div>
					<?php } ?>
				</div>
				<?php
				if ( ! $parallax_effect && ! empty( $slider['slider_bg_foreground_img'] ) && 'foreground' === $slider_img_type ) {
					?>

					<div class="slider-image"
						 data-swiper-animation="<?php echo esc_attr( $parallax_animation ); ?>"
						 data-duration="<?php echo esc_attr( $image_animation_duration ); ?>"
						 data-delay="<?php echo esc_attr( $image_ani_delay ); ?>"
					>
						<?php Fns::print_html( $render->render_slider_image( $slider ) ); ?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
</div>
