<?php
/**
 * Template: Layout 1
 *
 * @var $controllers            array
 * @var $product_type  array Widgets/Addons Settings
 * @package RadiusTheme\SBPRO
 */
// Do not allow directly accessing this file.
use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Helpers\FnsPro;

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}
global $product;
$variation_gallery_class = function_exists( 'rtwpvg' ) ? 'has-variation-gallery' : 'no-variation-gallery';
$add_to_cart_ajax_class  = ! empty( $controllers['enable_single_ajax_add_to_cart'] ) ? ' has-ajax-cart' : ' no-ajax-cart';
$has_meta                = $controllers['show_category'] || $controllers['show_sku'] ? true : false;
$custom_ordering         = $controllers['product_content_ordering'];
$order                   = FnsPro::generate_highlighted_product_custom_order( $custom_ordering );
$content_order_class     = $controllers['product_custom_ordering'] ? 'has-product-custom-order' : '';
?>
<div  class="rtsb-highlighted-product single-product woocommerce <?php echo esc_attr( $variation_gallery_class . ' ' . $content_order_class ); ?>" style="<?php echo esc_attr( $order ); ?>">
		<div id="product-<?php the_ID(); ?>" <?php wc_product_class( 'product product-item', $product ); ?>>
			<?php
			if ( ! empty( $controllers['sale_flash_badge'] ) ) {
				woocommerce_show_product_sale_flash();
			}
			if ( $controllers['show_image'] ) {
				woocommerce_show_product_images();
			}
			?>
			<div  class="rtsb-highlighted-product-content">
				<div class="content-heading">
					<?php
					if ( $controllers['show_category'] && has_term( '', 'product_cat', $product->get_id() ) ) {
						?>
						<div class="product-meta">
							<div class="rtsb-product-categories">
							<?php
							echo wc_get_product_category_list( $product->get_id(), ', ', '<span class="posted_in">', '</span>' );  // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
							?>
							</div>

					</div>
						<?php
					}
					?>
					<?php
					if ( $controllers['show_rating'] ) {
						Fns::get_product_simple_rating_html();
					}
					?>
				</div>
				<?php
				if ( $controllers['show_sku'] && wc_product_sku_enabled() && ( $product->get_sku() || $product->is_type( 'variable' ) ) ) {
					$sku = $product->get_sku() ? $product->get_sku() : esc_html__( 'N/A', 'shopbuilder-pro' );
					?>
					<div class="rtsb-product-sku">
						<?php do_action( 'woocommerce_product_meta_start' ); ?>
						<span class="sku-wrapper">
							<?php if ( $controllers['sku_label_text'] ) { ?>
								<span class="sku-label"><?php echo esc_html( $controllers['sku_label_text'] ); ?></span>
							<?php } ?>
							<span class="sku-value"><?php echo esc_html( $sku ); ?></span>
						</span>
					</div>
					<?php
				}
				if ( $controllers['show_title'] ) {
					?>
					<h2 class="product_title"><?php echo esc_html( $product->get_name() ); ?></h2>
				<?php } if ( $controllers['show_price'] ) { ?>
					<div class="rtsb-product-price">
						<?php woocommerce_template_single_price(); ?>
					</div>
				<?php } if ( $controllers['show_description'] ) { ?>
					<p class="short-description"><?php echo wp_kses_post( $product->get_short_description() ); ?></p>
					<?php
				}
				if ( $controllers['show_product_stock_shortcode'] ) {
					$show_stock_text     = $controllers['show_stock_text'] ?: 'no';
					$show_stock_progress = $controllers['show_stock_progress'] ?: 'no';
					$stock_text          = $controllers['stock_text'] ?: '';
					$stock_text_position = $controllers['stock_text_position'] === 'bottom' ? 'bottom-position' : 'top-position';
					$shortcode           = '[product_stock_count wrapper_class="' . $stock_text_position . '" stock_text="' . $stock_text . '" show_stock_text="' . $show_stock_text . '" show_stock_progress="' . $show_stock_progress . '"/]';
					Fns::print_html( do_shortcode( $shortcode ) );
				}
				if ( $controllers['show_add_to_cart'] ) {
					?>
					<div class="rtsb-product-add-to-cart has-cart-button quantity-<?php echo esc_attr( $controllers['quantity_style'] . $controllers['visibility'] . $add_to_cart_ajax_class ); ?>"  data-product-type='<?php echo esc_attr( $product_type ); ?>'>
					<?php woocommerce_template_single_add_to_cart(); ?>
					</div>
				<?php } if ( ! empty( $controllers['wishlist_button'] ) || ! empty( $controllers['comparison_button'] ) ) { ?>
					<div class="rtsb-actions-button rtsb-actions-button-widgets action-button-wrapper">
						<?php if ( ! empty( $controllers['wishlist_button'] ) ) { ?>
							<div class="wishlist-wrapper button-item">
								<?php do_action( 'rtsb/modules/wishlist/frontend/display' ); ?>
							</div>
						<?php } ?>
							<?php if ( ! empty( $controllers['comparison_button'] ) ) { ?>
							<div class="compare-wrapper button-item">
								<?php do_action( 'rtsb/modules/compare/frontend/display' ); ?>
							</div>
						<?php } ?>
					</div>
				<?php } ?>
			</div>
		</div>
</div>
