<?php
/**
 * Template: Lookbook Layout 1
 *
 * @package RadiusTheme\SBPRO
 */

/**
 * Template variables:
 *
 * @var $id                          string
 * @var $settings                    array
 * @var $image_args                  array
 * @var $pointers                    array
 * @var $render                      object
 * @var $wrapper_classes               string
 */

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Elementor\Helpers\AddonHelpersPro;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

$wrapper_attributes = [
	'class' => $wrapper_classes,
];

$render->add_attribute( 'rtsb_hotspots_wrapper_attr_' . $id, $wrapper_attributes );
?>
<div <?php Fns::print_html( $render->get_attribute_string( 'rtsb_hotspots_wrapper_attr_' . $id ) ); ?>>
	<div class="image-container">
		<?php
		// Render Image.
		AddonHelpersPro::render_general_image( $image_args );
		?>
	</div>
	<div class="popup-pointer-buttons" data-trigger="<?php echo esc_attr( $settings['hotspots_pointer_trigger'] ?? 'click' ); ?>">
		<?php
		foreach ( $pointers as $pointer ) {
			$repeater_id      = $pointer['_id'];
			$repeater_title   = $pointer['hotspot_title'] ?? '';
			$repeater_content = $pointer['hotspot_content'] ?? '';
			$repeater_icon    = $pointer['hotspot_icon'] ?? [];
			$item_attributes  = [
				'class'         => implode(
					' ',
					[
						'hotspot-button',
						'elementor-repeater-item-' . esc_attr( $pointer['_id'] ),
					]
				),
				'aria-expanded' => 'false',
			];

			$render->add_attribute( 'rtsb_hotspot_pointer_attr_' . $repeater_id, $item_attributes );
			?>
			<div <?php Fns::print_html( $render->get_attribute_string( 'rtsb_hotspot_pointer_attr_' . $repeater_id ) ); ?>>
				<div class="hotspot-data">
					<div class="data-wrapper">
						<?php
						if ( ! empty( $repeater_icon['value'] ) ) {
							?>
							<div class="hotspot-icon"><?php Fns::print_html( Fns::icons_manager( $repeater_icon, 'top-icon' ) ); ?></div>
							<?php
						}

						if ( ! empty( $repeater_title ) ) {
							?>
							<div class="hotspot-title"><?php echo esc_html( $repeater_title ); ?></div>
							<?php
						}

						if ( ! empty( $repeater_content ) ) {
							?>
							<div class="hotspot-content"><?php echo wp_kses_post( $repeater_content ); ?></div>
							<?php
						}
						?>
					</div>
				</div>
			</div>
			<?php
		}
		?>
	</div>
</div>
