<?php
/**
 * Template: Lookbook Layout 1
 *
 * @package RadiusTheme\SBPRO
 */

/**
 * Template variables:
 *
 * @var $id                          string
 * @var $settings                    array
 * @var $image_args                  array
 * @var $pointers                    array
 * @var $render                      object
 * @var $wrapper_classes               string
 */

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Elementor\Helpers\AddonHelpersPro;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

$wrapper_attributes = [
	'class' => $wrapper_classes,
];

$render->add_attribute( 'rtsb_lookbook_wrapper_attr_' . $id, $wrapper_attributes );
?>
<div <?php Fns::print_html( $render->get_attribute_string( 'rtsb_lookbook_wrapper_attr_' . $id ) ); ?>>
	<div class="image-container">
		<?php
		// Render Image.
		AddonHelpersPro::render_general_image( $image_args );
		?>
	</div>
	<div class="popup-pointer-buttons" data-trigger="<?php echo esc_attr( $settings['lookbook_pointer_trigger'] ?? 'click' ); ?>">
		<?php
		foreach ( $pointers as $pointer ) {
			$repeater_id     = $pointer['_id'];
			$item_attributes = [
				'class'           => implode(
					' ',
					[
						'pointer-button',
						'elementor-repeater-item-' . esc_attr( $pointer['_id'] ),
					]
				),
				'data-product-id' => absint( $pointer['pointer_product'] ?? 0 ),
				'aria-expanded'   => 'false',
			];

			$render->add_attribute( 'rtsb_lookbook_pointer_attr_' . $repeater_id, $item_attributes );
			?>
			<div <?php Fns::print_html( $render->get_attribute_string( 'rtsb_lookbook_pointer_attr_' . $repeater_id ) ); ?>>
				<div class="product-data"><div class="data-loader"></div></div>
			</div>
			<?php
		}
		?>
	</div>
</div>
