<?php
/**
 * Template variables:
 *
 * @var $controllers        array settings as array
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$downloads = WC()->customer->get_downloadable_products();

$has_downloads    = (bool) $downloads;
$wrapper_classes  = $controllers['striped_row_active'] ? 'has-striped-row' : 'no-striped-row';
$wrapper_classes .= ! empty( $controllers['table_horizontal_scroll_on_mobile'] ) ? ' rtsb-table-horizontal-scroll-on-mobile' : '';
?>
<section class="rtsb-myacount-page <?php echo esc_attr( $wrapper_classes ); ?>">
<?php
	do_action( 'woocommerce_before_account_downloads', $has_downloads );
?>

<?php if ( $has_downloads ) : ?>

	<?php do_action( 'woocommerce_before_available_downloads' ); ?>

	<?php do_action( 'woocommerce_available_downloads', $downloads ); ?>

	<?php do_action( 'woocommerce_after_available_downloads' ); ?>

<?php else : ?>
<div class="rtsb-notice">
	<div class="wc-block-components-notice-banner is-info" role="alert">
		<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" aria-hidden="true" focusable="false">
			<path d="M12 3.2c-4.8 0-8.8 3.9-8.8 8.8 0 4.8 3.9 8.8 8.8 8.8 4.8 0 8.8-3.9 8.8-8.8 0-4.8-4-8.8-8.8-8.8zm0 16c-4 0-7.2-3.3-7.2-7.2C4.8 8 8 4.8 12 4.8s7.2 3.3 7.2 7.2c0 4-3.2 7.2-7.2 7.2zM11 17h2v-6h-2v6zm0-8h2V7h-2v2z"></path>
		</svg>
		<div class="wc-block-components-notice-banner__content">
			<a class="button wc-forward" href="<?php echo esc_url( apply_filters( 'woocommerce_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ); ?>">
				<?php esc_html_e( 'Browse products', 'shopbuilder-pro' ); ?>
			</a>
			<?php esc_html_e( 'No downloads available yet.', 'shopbuilder-pro' ); ?>
		</div>
	</div>
</div>
<?php endif; ?>

<?php
	do_action( 'woocommerce_after_account_downloads', $has_downloads );
?>
</section>
