<?php
/**
 * Template variables:
 *
 * @var $controllers        array settings as array
 * @var $order        array settings as array
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
<section class="rtsb-myacount-page">
    <p>
		<?php
		printf(
		/* translators: 1: order number 2: order date 3: order status */
			esc_html__( 'Order #%1$s was placed on %2$s and is currently %3$s.', 'shopbuilder-pro' ),
			'<mark class="order-number">' . $order->get_order_number() . '</mark>', // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			'<mark class="order-date">' . wc_format_datetime( $order->get_date_created() ) . '</mark>', // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			'<mark class="order-status">' . wc_get_order_status_name( $order->get_status() ) . '</mark>' // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		);
		?>
    </p>
</section>
