<?php
/**
 * Template variables:
 *
 * @var $controllers        array settings as array
 * @var $order        array settings as array
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
if ( ! $order ) {
	return;
}

$order_items        = $order->get_items( apply_filters( 'woocommerce_purchase_order_item_types', 'line_item' ) );
$show_purchase_note = $order->has_status( apply_filters( 'woocommerce_purchase_note_order_statuses', [ 'completed', 'processing' ] ) );
$wrapper_classes    = ! empty( $controllers['table_horizontal_scroll_on_mobile'] ) ? ' rtsb-table-horizontal-scroll-on-mobile' : '';
$actions            = array_filter(
	wc_get_account_orders_actions( $order ),
	function ( $key ) {
		return 'view' !== $key;
	},
	ARRAY_FILTER_USE_KEY
);

?>
<section class="rtsb-myacount-page<?php echo esc_attr( $wrapper_classes ); ?>">
	<?php do_action( 'woocommerce_order_details_before_order_table', $order ); ?>
	<?php
	if ( $controllers['show_title'] === 'yes' ) {
		?>
		<h2 class="woocommerce-order-details__title"><?php esc_html_e( 'Order details', 'shopbuilder-pro' ); ?></h2>
	<?php } ?>

	<table class="woocommerce-table woocommerce-table--order-details shop_table order_details order-details-widget">

		<thead>
		<tr>
			<th class="woocommerce-table__product-name product-name"><?php esc_html_e( 'Product', 'shopbuilder-pro' ); ?></th>
			<th class="woocommerce-table__product-table product-total"><?php esc_html_e( 'Total', 'shopbuilder-pro' ); ?></th>
		</tr>
		</thead>

		<tbody>
		<?php
		do_action( 'woocommerce_order_details_before_order_table_items', $order );

		foreach ( $order_items as $item_id => $item ) {
			$product = $item->get_product();

			wc_get_template(
				'order/order-details-item.php',
				[
					'order'              => $order,
					'item_id'            => $item_id,
					'item'               => $item,
					'show_purchase_note' => $show_purchase_note,
					'purchase_note'      => $product ? $product->get_purchase_note() : '',
					'product'            => $product,
				]
			);
		}
		do_action( 'woocommerce_order_details_after_order_table_items', $order );
		?>
		</tbody>
		<?php
		if ( ! empty( $actions ) ) :
			?>
			<tfoot>
			<tr>
				<th class="order-actions--heading"><?php esc_html_e( 'Actions', 'shopbuilder-pro' ); ?>:</th>
				<td class="order-actions">
					<?php
					$wp_button_class = wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '';
					foreach ( $actions as $key => $action ) { // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
						if ( empty( $action['aria-label'] ) ) {
							// Generate the aria-label based on the action name.
							/* translators: %1$s Action name, %2$s Order number. */
							$action_aria_label = sprintf( __( '%1$s order number %2$s', 'shopbuilder-pro' ), $action['name'], $order->get_order_number() );
						} else {
							$action_aria_label = $action['aria-label'];
						}
						echo '<a href="' . esc_url( $action['url'] ) . '" class="woocommerce-button' . esc_attr( $wp_button_class ) . ' button ' . sanitize_html_class( $key ) . ' order-actions-button " aria-label="' . esc_attr( $action_aria_label ) . '">' . esc_html( $action['name'] ) . '</a>';
						unset( $action_aria_label );
					}
					?>
				</td>
			</tr>
			</tfoot>
		<?php endif ?>
		<tfoot>
		<?php
		foreach ( $order->get_order_item_totals() as $key => $total ) {
			?>
			<tr>
				<th scope="row"><?php echo esc_html( $total['label'] ); ?></th>
				<td><?php echo ( 'payment_method' === $key ) ? esc_html( $total['value'] ) : wp_kses_post( $total['value'] ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></td>
			</tr>
			<?php
		}
		?>
		<?php if ( $order->get_customer_note() ) : ?>
			<tr>
				<th><?php esc_html_e( 'Note:', 'shopbuilder-pro' ); ?></th>
				<td><?php echo wp_kses_post( nl2br( wptexturize( $order->get_customer_note() ) ) ); ?></td>
			</tr>
		<?php endif; ?>
		</tfoot>
	</table>

</section>
