<?php
/**
 * Template variables:
 *
 * @var $controllers        array settings as array
 * @var $is_builder_mode    bool Editor Mode status
 */

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Modules\CustomizeMyAccount\CustomizeMyAccountFns;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

do_action( 'woocommerce_before_account_navigation' );

$endpoints = CustomizeMyAccountFns::get_endpoints_options();
?>
<section class="rtsb-myacount-page rtsb-custom-wc-nav">
	<nav class="woocommerce-MyAccount-navigation">
		<ul>
			<?php
			foreach ( wc_get_account_menu_items() as $endpoint => $label ) :
				if ( 'on' !== ( $endpoints[ $endpoint ]['menu_visibility'] ?? '' ) ) {
					continue;
				}

				$icon_name = $endpoint . '_icon';
				$icon_html = '';
				$has_icon  = ( ! empty( $endpoints[ $endpoint ]['icon'] ) && 'none' !== $endpoints[ $endpoint ]['icon'] ) || ( ! empty( $controllers[ $icon_name ]['value'] ) );

				if ( empty( $controllers[ $icon_name ]['value'] ) ) {
					$icon_html .= CustomizeMyAccountFns::get_icon_html( $endpoints[ $endpoint ] ?? '', $endpoint, false );
				} else {
					$icon_html .= Fns::icons_manager( $controllers[ $icon_name ] );
				}
				?>

				<li class="<?php echo esc_attr( wc_get_account_menu_item_classes( $endpoint ) . ' icon-' . $controllers['icon_alignment'] . ( $has_icon ? ' has-custom-icon' : ' no-custom-icon' ) ); ?>">
					<?php
					if ( 'left' === $controllers['icon_alignment'] ) {
						?>
							<span class="icon <?php echo esc_attr( $icon_name ); ?>">
								<?php Fns::print_html( $icon_html, true ); ?>
							</span>
						<?php
					}

					// Link attributes.
					$link_attributes = CustomizeMyAccountFns::get_link_attributes( $endpoints, $endpoint );
					?>
					<a href="<?php echo esc_url( $link_attributes['href'] ); ?>"<?php Fns::print_html( $link_attributes['target'] ); ?>><?php echo esc_html( $label ); ?></a>

					<?php
					if ( 'right' === $controllers['icon_alignment'] ) {
						?>
						<span class="icon <?php echo esc_attr( $icon_name ); ?>">
							 <?php Fns::print_html( $icon_html, true ); ?>
						</span>
						<?php
					}
					?>
				</li>
			<?php endforeach; ?>
		</ul>
	</nav>
</section>

<?php do_action( 'woocommerce_after_account_navigation' ); ?>
