<?php
/**
 * Template variables:
 *
 * @var $controllers        array settings as array
 * @var $key reset password hidden key
 * @var $login reset password login values
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

do_action( 'woocommerce_before_reset_password_form' );
?>
	<form method="post" class="woocommerce-ResetPassword lost_reset_password">

        <p class="info-text"><?php echo apply_filters( 'woocommerce_reset_password_message', esc_html__( 'Enter a new password below.', 'shopbuilder-pro' ) ); ?></p><?php // @codingStandardsIgnoreLine ?>

		<p class="woocommerce-form-row woocommerce-form-row--first form-row form-row-first">
			<label for="password_1"><?php esc_html_e( 'New password', 'shopbuilder-pro' ); ?>&nbsp;<span class="required">*</span></label>
			<input type="password" class="woocommerce-Input woocommerce-Input--text input-text" name="password_1" id="password_1" autocomplete="new-password" />
		</p>
		<p class="woocommerce-form-row woocommerce-form-row--last form-row form-row-last">
			<label for="password_2"><?php esc_html_e( 'Re-enter new password', 'shopbuilder-pro' ); ?>&nbsp;<span class="required">*</span></label>
			<input type="password" class="woocommerce-Input woocommerce-Input--text input-text" name="password_2" id="password_2" autocomplete="new-password" />
		</p>

		<input type="hidden" name="reset_key" value="<?php echo esc_attr( $key ); ?>" />
		<input type="hidden" name="reset_login" value="<?php echo esc_attr( $login ); ?>" />

		<div class="clear"></div>

		<?php do_action( 'woocommerce_resetpassword_form' ); ?>

		<p class="woocommerce-form-row form-row">
			<input type="hidden" name="wc_reset_password" value="true" />
			<button type="submit" class="woocommerce-Button button<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>" value="<?php esc_attr_e( 'Save', 'shopbuilder-pro' ); ?>"><?php esc_html_e( 'Save', 'shopbuilder-pro' ); ?></button>
		</p>

		<?php wp_nonce_field( 'reset_password', 'woocommerce-reset-password-nonce' ); ?>

	</form>
<?php
do_action( 'woocommerce_after_reset_password_form' );

