<?php
/**
 * Template variables:
 *
 * @var $controllers  array settings as array
 * @var $content  string
 */

use RadiusTheme\SB\Helpers\Fns;
global $product;

if ( empty( $product ) ) {
	return;
}
$icon = '';
if ( ! empty( $controllers['count_label_icon'] ) ) {
	$icon = '<span class="icon">' . Fns::icons_manager( $controllers['count_label_icon'] ) . '</span>';
}
?>

<div class="rtsb-product-flash-sale-countdown <?php echo esc_attr( $controllers['layout_style'] ); ?>">
	<div class="label-wrapper">
		<?php
		Fns::print_html( $icon );
		if ( $controllers['count_text_label'] ) {
			?>
			<span class="label-text"><?php echo esc_html( $controllers['count_text_label'] ); ?></span>
			<?php
		}
		?>

	</div>
	<?php do_action( 'rtsb/modules/flash_sale_countdown/frontend/display' ); ?>
</div>
