<?php
/**
 * Single Product tabs
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
global $product, $post;

if ( empty( $product ) ) {
	return;
}


$product_tabs = apply_filters( 'woocommerce_product_tabs', [] );
$layout       = ! empty( $controllers['layout_style'] ) ? $controllers['layout_style'] : '';

if ( ! empty( $product_tabs ) ) : ?>
	<div class="rtsb-product-tabs custom-product-tabs tabs-<?php echo esc_attr( $layout ); ?>">
		<?php
		foreach ( $product_tabs as $key => $product_tab ) :
			?>
			<div class="rtsb-tab-accordion-item">
				<h2 class="rtsb-accordion-title" id="tab-title-<?php echo esc_attr( $key ); ?>">
					<?php echo wp_kses_post( apply_filters( 'woocommerce_product_' . $key . '_tab_title', $product_tab['title'], $key ) ); ?>
				</h2>
				<div class="rtsb-product-accordion-content rtsb-custom-tab-panel-<?php echo esc_attr( $key ); ?> " id="tab-<?php echo esc_attr( $key ); ?>">
					<?php
					if ( isset( $product_tab['callback'] ) ) {
						call_user_func( $product_tab['callback'], $key, $product_tab );
					}
					?>
				</div>
			</div>
		<?php endforeach; ?>
	</div>

<?php endif; ?>
