<?php
/**
 * Template variables:
 *
 * @var $controllers        array settings as array
 * @var $is_builder_mode    bool Editor Mode status
 * @var $order
 */

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

?>
<section class="rtsb-order-thankyou woocommerce-customer-details">
    <h2 class="woocommerce-column__title"><?php esc_html_e( 'Billing address', 'shopbuilder-pro' ); ?></h2>
    <address>
        <?php echo wp_kses_post( $order->get_formatted_billing_address( esc_html__( 'N/A', 'shopbuilder-pro' ) ) ); ?>

        <?php if ( $order->get_billing_phone() ) : ?>
            <p class="woocommerce-customer-details--phone"><?php echo esc_html( $order->get_billing_phone() ); ?></p>
        <?php endif; ?>

        <?php if ( $order->get_billing_email() ) : ?>
            <p class="woocommerce-customer-details--email"><?php echo esc_html( $order->get_billing_email() ); ?></p>
        <?php endif; ?>
    </address>
</section>
<?php
