<?php
/**
 * Customer partial pay reminder email.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/partial-pay-reminder.php.
 *
 * @package RadiusTheme\SBPRO
 */

/**
 * Template variables:
 *
 * @var $email                   object
 * @var $email_heading           string
 * @var $product_name            string
 * @var $order                   object
 * @var $sent_to_admin           bool
 * @var $plain_text              bool
 * @var $balance_pay_link        string
 * @var $next_due_date           string
 * @var $remaining_amount        string
 * @var $store_email             string
 */

use RadiusTheme\SB\Helpers\Fns;

defined( 'ABSPATH' ) || exit();

do_action( 'woocommerce_email_header', $email_heading, $email );

$content      = ! empty( $email->email_content ) ? $email->email_content : '';
$order_id     = $email->object->get_id();
$customer     = $order->get_formatted_billing_full_name();
$site_title   = $email->get_blogname();
$site_address = wp_parse_url( home_url(), PHP_URL_HOST );
$site_url     = wp_parse_url( home_url(), PHP_URL_HOST );
$order_link   = '<a href="' . $order->get_view_order_url() . '">' . esc_html__( 'Order#', 'shopbuilder-pro' ) . $order_id . '</a>';

echo '<p>';

ob_start();
do_action( 'woocommerce_email_order_details', $order, $sent_to_admin, $plain_text, $email );
$order_details = ob_get_clean();

$balance_pay_link = '<a href="' . esc_url( $balance_pay_link ) . '" target="_blank">' . esc_html__( 'Click here to pay the remaining balance.', 'shopbuilder-pro' ) . '</a>';
$next_due_date    = '<strong style="display: inline-block;min-width: 150px">' . esc_html__( 'Due Date', 'shopbuilder-pro' ) . '</strong>: ' . gmdate( 'F j, Y', strtotime( $next_due_date ) );
$remaining_amount = '<strong style="display: inline-block;min-width: 150px">' . esc_html__( 'Remaining Amount', 'shopbuilder-pro' ) . '</strong>: ' . wc_price( $remaining_amount );

$content = nl2br(
	str_replace(
		[
			'{customer_name}',
			'{order_number}',
			'{order_link}',
			'{site_title}',
			'{site_address}',
			'{site_url}',
			'{store_email}',
			'{next_due_date}',
			'{remaining_amount}',
			'{balance_pay_link}',
		],
		[
			ucwords( $customer ),
			$order_link,
			$order_link,
			$site_title,
			$site_address,
			$site_url,
			$store_email,
			$next_due_date,
			$remaining_amount,
			$balance_pay_link,
		],
		$content
	)
);

$content = str_replace( '{order_details}', $order_details, $content );

Fns::print_html( $content, true );
echo '</p>';

do_action( 'woocommerce_email_footer' );
