<?php
/**
 * Email Template Table
 *
 * Template variables:
 *
 * @var string $email_body
 * @var string $recipient_name
 * @var string $current_balance
 * @var string $card_number
 * @var string $expiration_date
 * @var string $card_message
 * @var string $heading
 */

use RadiusTheme\SB\Helpers\Fns;

?>

<table cellspacing="0" cellpadding="10" border="0" width="100%" style="border-collapse: collapse; font-family: sans-serif;">
	<tr>
		<td colspan="2"><?php Fns::print_html( $email_body ); ?></td>
	</tr>
	<?php if ( ! empty( $current_balance ) ) : ?>
		<tr>
			<td><strong><?php esc_html_e( 'Current Balance:', 'shopbuilder-pro' ); ?></strong></td>
			<td><?php Fns::print_html( $current_balance ); ?></td>
		</tr>
	<?php endif; ?>

	<?php if ( ! empty( $card_number ) ) : ?>
		<tr>
			<td><strong><?php esc_html_e( 'Card Number:', 'shopbuilder-pro' ); ?></strong></td>
			<td><?php echo esc_html( $card_number ); ?></td>
		</tr>
	<?php endif; ?>

	<?php if ( ! empty( $expiration_date ) ) : ?>
		<tr>
			<td><strong><?php esc_html_e( 'Valid Until:', 'shopbuilder-pro' ); ?></strong></td>
			<td><?php echo esc_html( $expiration_date ); ?></td>
		</tr>
	<?php endif; ?>

	<?php if ( ! empty( $card_message ) ) : ?>
		<tr>
			<td><strong><?php esc_html_e( 'Message:', 'shopbuilder-pro' ); ?></strong></td>
			<td><?php echo nl2br( esc_html( $card_message ) ); ?></td>
		</tr>
	<?php endif; ?>

</table>