<?php
/**
 * Gift Cards List Template
 *
 * Template variables:
 *
 * @var \WP_Post[] $gift_cards
 * @var int $paged
 * @var int $total_pages
 */

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Modules\GiftCard\GiftCardFns;

if ( empty( $gift_cards ) ) {
	echo '<p>' . esc_html__( 'No gift cards found.', 'shopbuilder-pro' ) . '</p>';
	return;
}
?>
	<table class="rtsb-gift-card-table shop_table shop_table_responsive">
		<thead>
		<tr>
			<th><?php esc_html_e( 'Card Code', 'shopbuilder-pro' ); ?></th>
			<th><?php esc_html_e( 'Amount', 'shopbuilder-pro' ); ?></th>
			<th><?php esc_html_e( 'Remaining Balance', 'shopbuilder-pro' ); ?></th>
			<th><?php esc_html_e( 'Expiry Date', 'shopbuilder-pro' ); ?></th>
			<th><?php esc_html_e( 'Action', 'shopbuilder-pro' ); ?></th>
		</tr>
		</thead>
		<tbody>
		<?php
		foreach ( $gift_cards as $card ) :
			$giftCard        = GiftCardFns::get_card_by_id( $card->ID );
			$expiration_date = $giftCard->get_card_data( 'expiration_date' );
			$format          = get_option( 'date_format' ) . ' ' . get_option( 'time_format' );
			$expiration_date = ! empty( $expiration_date ) ? date_i18n( $format, strtotime( $expiration_date ) ) : esc_html__( 'Lifetime', 'shopbuilder-pro' );
			$view_url        = wc_get_endpoint_url( 'rtsb-view-card', $card->ID, wc_get_page_permalink( 'myaccount' ) );
			?>
			<tr>
				<td data-title="<?php esc_attr_e( 'Card Code', 'shopbuilder-pro' ); ?>" ><?php echo esc_html( $giftCard->get_card_data( 'card_number' ) ); ?></td>
				<td data-title="<?php esc_attr_e( 'Amount', 'shopbuilder-pro' ); ?>" ><?php Fns::print_html( wc_price( $giftCard->get_card_data( 'card_amount' ) ) ); ?></td>
				<td data-title="<?php esc_attr_e( 'Remaining Balance', 'shopbuilder-pro' ); ?>" ><?php Fns::print_html( wc_price( $giftCard->get_card_data( 'remaining_balance' ) ) ); ?></td>
				<td data-title="<?php esc_attr_e( 'Expiry Date', 'shopbuilder-pro' ); ?>" ><?php echo esc_html( $expiration_date ); ?></td>
				<td data-title="<?php esc_attr_e( 'Action', 'shopbuilder-pro' ); ?>" ><a href="<?php echo esc_url( $view_url ); ?>" class="button"><?php esc_html_e( 'View', 'shopbuilder-pro' ); ?></a></td>
			</tr>
		<?php endforeach; ?>
		</tbody>
	</table>

<?php
if ( $total_pages > 1 ) :
	$current_endpoint = WC()->query->get_current_endpoint();
	$current_url      = trailingslashit( wc_get_endpoint_url( $current_endpoint, '', wc_get_page_permalink( 'myaccount' ) ) );

	?>
	<div class="rtsb-giftcard-nav" style="margin-top: 20px;">
		<?php if ( $paged > 1 ) : ?>
			<a class="button" href="<?php echo esc_url( $current_url . ( $paged - 1 ) . '/' ); ?>">&larr; <?php esc_html_e( 'Previous', 'shopbuilder-pro' ); ?></a>
		<?php endif; ?>
		<?php if ( $paged < $total_pages ) : ?>
			<a class="button" href="<?php echo esc_url( $current_url . ( $paged + 1 ) . '/' ); ?>"><?php esc_html_e( 'Next', 'shopbuilder-pro' ); ?> &rarr;</a>
		<?php endif; ?>
	</div>
<?php endif; ?>