<?php
/**
 * Template variables:
 *
 * @var $email_heading String Heading
 * @var $product_name String Product Name
 * @var $recipient_email string Recipient Email.
 * @var $card_number string Card Number.
 * @var $card_amount string Card Amount.
 * @var $remaining_balance string Remaining Balance.
 * @var $sender_name string Sender Name.
 * @var $recipient_name string Recipient Name.
 * @var $expiration_date string Expiration Date.
 * @var $card_message string Card Message.
 * @var $redeem_url String Cart Url.
 * @var $email_body String Email Body.
 * @var $email_footer String Email Footer.
 */

use RadiusTheme\SB\Helpers\Fns;

?>
<?php
if ( ! empty( $email ) ) {
	do_action( 'woocommerce_email_header', $email_heading, $email );
	?>
	<div style="margin: 0 auto 10px;max-width:450px;box-sizing: border-box;text-align: left;">
		<?php Fns::print_html( $email_body, true ); ?>
	</div>
<?php } ?>
<div style="<?php echo ! empty( $email ) ? 'min-height: 300px' : ''; ?>">
	<div style="<?php echo ! empty( $email ) ? 'margin:auto;' : ''; ?> max-width:450px;box-sizing: border-box;border:1px solid #ddd;text-align: left;border-radius:12px;padding:25px 30px 40px; background: linear-gradient(135deg, #FFD700, #E6BE8A, #C5A300);box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);font-family:sans-serif;color:#333;">
		<div style="margin-bottom: 30px;text-align: center;font-size: 20px; font-weight: 700;">
			<?php echo esc_html( $product_name ); ?>
		</div>
		<div style="margin-bottom: 15px;">
			<div style="margin-bottom: 5px;">
				<?php esc_html_e( 'Card Limit', 'shopbuilder-pro' ); ?>
			</div>
			<div style="font-size: 20px;font-weight: 700;">
				<?php Fns::print_html( $card_amount ); ?>
			</div>
		</div>
		<div style="margin-bottom: 15px;">
			<div style="margin-bottom: 5px;">
				<?php esc_html_e( 'Card Number', 'shopbuilder-pro' ); ?>
			</div>
			<div style="margin-bottom: 5px;font-size: 20px;font-weight: 700;">
				<?php echo esc_html( $card_number ); ?>
			</div>
		</div>
		<div style="display: flex; align-items: center; justify-content: space-between; padding-top: 20px;">
			<a style="background: #0066ff; padding: 10px 15px;border-radius: 5px;display: inline-flex;color: #fff;text-transform: uppercase;text-decoration: none;" href="<?php echo esc_url( $redeem_url ); ?>">
				<?php esc_html_e( 'Redeem', 'shopbuilder-pro' ); ?>
			</a>
			<div style="float: right;">
				<strong><?php esc_html_e( 'Valid Till', 'shopbuilder-pro' ); ?></strong>: <?php echo esc_html( $expiration_date ); ?>
			</div>
		</div>
	</div>
</div>

<?php
if ( ! empty( $email ) ) {
	?>
	<div style="margin: 0 auto 10px;max-width:450px;box-sizing: border-box;text-align: left;">
		<?php Fns::print_html( $email_footer, true ); ?>
	</div>
	<?php
	do_action( 'woocommerce_email_footer' );
}