<?php
/**
 * Checkout Form
 *
 * @package RadiusTheme\SB
 */


defined( 'ABSPATH' ) || exit;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Modules\MultiStepsCheckout\MultiStepsCheckoutFns;

$options                 = Fns::get_options( 'modules', 'multi_step_checkout' );
$is_registration_enabled = version_compare( '3.0', WC()->version, '<=' ) ? $checkout->is_registration_enabled() : get_option( 'woocommerce_enable_signup_and_login_from_checkout' ) == 'yes';



$has_checkout_fields = version_compare( '3.0', WC()->version, '<=' ) ? $checkout->get_checkout_fields() : ( is_array( $checkout->checkout_fields ) && count( $checkout->checkout_fields ) > 0 );
$stop_at_login       = ( ! $is_registration_enabled && $checkout->is_registration_required() && ! is_user_logged_in() ) ? true : false;
$checkout_url        = apply_filters( 'woocommerce_get_checkout_url', version_compare( '2.5', WC()->version, '<=' ) ? wc_get_checkout_url() : WC()->cart->get_checkout_url() );
$show_login_step     = ! is_user_logged_in() && ( $options['login_step_visibility'] ?? '' );

// Both options disabled for "Guest" on the WP Admin -> WooCommerce -> Settings -> Accounts & Privacy page
if ( ! is_user_logged_in() && ! $is_registration_enabled && $checkout->is_registration_required() && $show_login_step ) {
	echo esc_html( apply_filters( 'woocommerce_checkout_must_be_logged_in_message', __( 'You must be logged in to checkout.', 'shopbuilder-pro' ) ) );

	return;
}

// Get the steps
$steps = MultiStepsCheckoutFns::checkout_steps();

// No checkout fields within the $checkout object
if ( ! $has_checkout_fields ) {
	unset( $steps['billing'] );
	unset( $steps['shipping'] );
}

// Show the tabs
do_action( 'rtrb_checkout_tab_before' );
$count_tab_item     = 0;
$number_of_steps    = ( ! $show_login_step ) ? count( $steps ) + 1 : count( $steps );
$current_step_title = ( ! $show_login_step ) ? 'login' : key( array_slice( $steps, 0, 1, true ) );

?>
<div class="rtrb-checkout-multistep-wrapper layout1">
<!-- Checkout steping -->
<div class="rtrb-checkout-tab-container">
	<ul class="rtrb-checkout-tab-item-wrap rtrb-checkout-<?php echo esc_attr( $number_of_steps ); ?>-tabs" data-current-title="<?php echo esc_attr( $current_step_title ); ?>">
		<?php if ( $show_login_step ) : ?>
			<li class="rtrb-checkout-tab-item current rtrb-checkout-login" data-step-title="login">
				<div class="rtrb-checkout-tab-text"><?php echo 'Login'; ?></div>
				<div class="rtrb-checkout-tab-number"><span><?php echo esc_html( ++$count_tab_item ); ?></span></div>
			</li>
		<?php endif; ?>

		<?php foreach ( $steps as $_id => $_step ) : ?>
			<?php $class = ( ! $show_login_step && $count_tab_item == 0 ) ? ' current' : ''; ?>
			<li class="rtrb-checkout-tab-item<?php echo esc_attr( $class ); ?> rtrb-checkout-<?php echo esc_attr( $_id ); ?>" data-step-title="<?php echo esc_attr( $_id ); ?>">
				<div class="rtrb-checkout-tab-text"><?php Fns::print_html( $_step['title'] ); ?></div>
				<div class="rtrb-checkout-tab-number"><span><?php echo $count_tab_item = $count_tab_item + 1; ?></span></div>
			</li>
		<?php endforeach; ?>
	</ul>
</div>
<?php do_action( 'rtrb_checkout_tab_after' ); ?>

<?php wc_print_notices(); ?>

<div class="rtrb-checkout-steps-wrapper">

	<div id="checkout_coupon" class="woocommerce_checkout_coupon" style="display: none;">
		<?php do_action( 'rtrb_checkout_woocommerce_checkout_coupon_form', $checkout ); ?>
	</div>

	<div id="woocommerce_before_checkout_form" class="woocommerce_before_checkout_form" data-step="<?php echo apply_filters( 'woocommerce_before_checkout_form_step', 'step-order' ); ?>" style="display: none;">
		<?php do_action( 'woocommerce_before_checkout_form', $checkout ); ?>
	</div>

	<?php
	// Login Form.

	if ( $show_login_step ) {
		do_action( 'rtrb_checkout_woocommerce_checkout_login_form', $checkout );
		if ( $stop_at_login ) :
			echo esc_html( apply_filters( 'woocommerce_checkout_must_be_logged_in_message', __( 'You must be logged in to checkout.', 'shopbuilder-pro' ) ) );
		endif;
	}

	if ( ! $stop_at_login ) :
		// Checkout Form.
		?>
		<form name="checkout" method="post" class="checkout woocommerce-checkout" action="<?php echo esc_url( $checkout_url ); ?>" enctype="multipart/form-data">
			<?php
			$first_step = ( $show_login_step ) ? '' : ' current';
			foreach ( $steps as $index => $value ) {
				$should_validate = ' should-validate';
				if ( $index == 'shipping' ) {
					$should_validate = '';
				}
				echo '<div class="rtrb-checkout-step-item ' . $value['class'] . $first_step . $should_validate . '">';
				if ( isset( $value['sections'] ) ) {
					foreach ( $value['sections'] as $_section ) {
						$action_name = ( strpos( $_section, 'woocommerce_' ) === 0 ) ? $_section : 'rtrb_step_content_' . $_section;
						do_action( $action_name );
					}
				} else {
					do_action( 'rtrb_step_content_' . $index );
				}
				echo '</div>';
				$first_step = '';
			}

			// Form Button markup.
			do_action( 'rtrb_step_checkout_button', $options );
			?>
		</form>

	<?php endif; ?>


	<?php do_action( 'woocommerce_after_checkout_form', $checkout ); ?>
</div>

</div>
