<?php
/**
 * My Account Custom Navigation Template.
 */

/**
 * Template variables:
 *
 * @var $data array Endpoint data
 */

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Modules\CustomizeMyAccount\CustomizeMyAccountFns;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

do_action( 'woocommerce_before_account_navigation' );
?>
<section class="rtsb-custom-wc-nav">
	<nav class="woocommerce-MyAccount-navigation">
		<ul>
			<?php
			foreach ( wc_get_account_menu_items() as $endpoint => $label ) {
				if ( 'on' !== ( $data[ $endpoint ]['menu_visibility'] ?? '' ) ) {
					continue;
				}

				$has_icon = ! empty( $data[ $endpoint ]['icon'] ) && 'none' !== $data[ $endpoint ]['icon'];
				?>
				<li class="<?php echo esc_attr( wc_get_account_menu_item_classes( $endpoint ) . ( $has_icon ? ' has-custom-icon' : '' ) ); ?>">
					<?php
					Fns::print_html( CustomizeMyAccountFns::get_icon_html( $data[ $endpoint ], $endpoint ), true );

					// Link attributes.
					$link_attributes = CustomizeMyAccountFns::get_link_attributes( $data, $endpoint );
					?>
					<a href="<?php echo esc_url( $link_attributes['href'] ); ?>"<?php Fns::print_html( $link_attributes['target'] ); ?>><?php echo esc_html( $label ); ?></a>
				</li>
				<?php
			}
			?>
		</ul>
	</nav>
</section>

<?php do_action( 'woocommerce_after_account_navigation' ); ?>
