<?php
/**
 * Template variables:
 *
 * @var $close_button           bool close button visibility
 * @var $item                   array Order data
 * @var $display_image      string Image url
 * @var $display_product        Display Product
 * @var $is_display_image       Display image
 * @var $cross_button_color     Cross Button Color
 */
use \RadiusTheme\SB\Helpers\Fns;
?>
<div class="rtsb-notifications-item">

	<?php if ( $is_display_image ) { ?>
		<div class="rtsb-notifications-item-avatar">
			<?php Fns::print_html( $display_image ); ?>
		</div>
	<?php } ?>
	<div class="rtsb-notifications-item-content">

		<span class="rtsb-notifications-item-address">
			<?php if ( ! empty( $display_user_name ) ) { ?>
			<span class="user-name">
				<?php echo esc_html( $item['display_name'] ); ?> -
			</span>
			<?php } ?>
			<?php
				printf(
					/* translators: addess */
					esc_html__( ' From %s', 'shopbuilder-pro' ),
					'<span class="user-address">' . $item['user_address'] . '</span>'
				);
				?>
		</span>

		<h4 class="rtsb-notifications-item-title">
			<?php
			ob_start();
			if ( ! empty( $product_link ) ) {
				?>
			 <a href="<?php echo esc_url( $display_product['product_url'] ); ?>" target="_blank"> <?php } ?>
				<?php echo esc_attr( $display_product['product_title'] ); ?>
				<?php
				if ( ! empty( $product_link ) ) {
					?>
					 </a>
					<?php
				}
				$title = ob_get_clean();
				printf(
				/* translators: product title with link */
					esc_html__( 'Purchased - %s ', 'shopbuilder-pro' ),
					$title
				);
				?>
		</h4>
		<span class="rtsb-notifications-item-message">
			 <?php echo esc_html__( 'About ', 'shopbuilder-pro' ) . esc_html( $item['order_time'] ); ?>
		</span>
	</div>

	<?php if ( $close_button ) { ?>
		<div class="rtsb-notifications-button">
			<span class="rtsb-notifications-delete" title="<?php echo esc_attr__( 'Notification will display after 24 hours', 'shopbuilder-pro' ); ?>">
				<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" fill="<?php echo esc_attr( ! empty( $cross_button_color ) ? $cross_button_color : '#ffffff' ); ?>" height="10px" width="10px" version="1.1" viewBox="0 0 490 490" xml:space="preserve">
					<polygon points="456.851,0 245,212.564 33.149,0 0.708,32.337 212.669,245.004 0.708,457.678 33.149,490 245,277.443 456.851,490   489.292,457.678 277.331,245.004 489.292,32.337 "/>
				</svg>
			</span>
		</div>
	<?php } ?>
</div>
