<?php
/**
 * Template variables:
 *
 * @var $steps
 */

	use RadiusTheme\SB\Helpers\Fns;
?>
<div class="rtsb-checkout-page-menu rtsb-mb-30">
	<nav class="shopify-multistep-menu">
		<ul>
			<?php
			$img = '<img src="data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTIiIGhlaWdodD0iNyIgdmlld0JveD0iMCAwIDEyIDciIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+CjxwYXRoIGQ9Ik02LjQxNjY3IDYuNjk0NDRDNi4xNjI3NiA2LjY5NDQ0IDUuOTM3MDcgNi42MDk4MSA1Ljc2Nzc5IDYuNDQwNTRMMS4yNTM5MSAxLjkyNjY1QzAuODg3MTUzIDEuNTg4MTEgMC44ODcxNTMgMC45OTU2NiAxLjI1MzkxIDAuNjU3MTE4QzEuNTkyNDUgMC4yOTAzNjUgMi4xODQ5IDAuMjkwMzY1IDIuNTIzNDQgMC42NTcxMThMNi40MTY2NyA0LjUyMjE0TDEwLjI4MTcgMC42NTcxMThDMTAuNjIwMiAwLjI5MDM2NSAxMS4yMTI3IDAuMjkwMzY1IDExLjU1MTIgMC42NTcxMThDMTEuOTE4IDAuOTk1NjYgMTEuOTE4IDEuNTg4MTEgMTEuNTUxMiAxLjkyNjY1TDcuMDM3MzMgNi40NDA1NEM2Ljg2ODA2IDYuNjA5ODEgNi42NDIzNiA2LjY5NDQ0IDYuNDE2NjcgNi42OTQ0NFoiIGZpbGw9ImN1cnJlbnRDb2xvciIvPgo8L3N2Zz4K">';
			if ( $steps['show_cart'] ) {
				?>
			<li><a href="<?php echo esc_url( wc_get_cart_url() ); ?>"><?php echo esc_html( $steps['cart_text'] ?: __( 'Cart', 'shopbuilder-pro' ) ); ?></a></li>
			<li class="rtsb-img-icon-angel"> <?php Fns::print_html( $img, true ); ?> </li>
			<?php } ?>
			<li class="active"><a href="#billingAddress"><?php echo esc_html( $steps['billing_text'] ?: __( 'Billing', 'shopbuilder-pro' ) ); ?> </a></li>
			<li class="rtsb-img-icon-angel"> <?php Fns::print_html( $img, true ); ?> </li>
			<?php if ( true === WC()->cart->needs_shipping_address() ) { ?>
				<li class="active"><a href="#shippingAddress"> <?php echo esc_html( $steps['shipping_text'] ?: __( 'Shipping', 'shopbuilder-pro' ) ); ?> </a></li>
				<li class="rtsb-img-icon-angel"> <?php Fns::print_html( $img, true ); ?> </li>
				<li><a href="#shippingMethod"><?php echo esc_html( $steps['shipping_method_text'] ?: __( 'Shipping Method', 'shopbuilder-pro' ) ); ?> </a></li>
				<li class="rtsb-img-icon-angel"> <?php Fns::print_html( $img, true ); ?> </li>
			<?php } ?>
			<li><a href="#makePayment"> <?php echo esc_html( $steps['payment_text'] ?: __( 'Payment', 'shopbuilder-pro' ) ); ?> </a></li>
		</ul>
	</nav>
</div>