<?php
/**
 * Template variables:
 *
 * @var $controllers  array settings as array
 * @var $content  string
 * @var $settings  array
 */

global $product;

if ( empty( $product ) ) {
	return;
}

$product_id      = $product->get_id();
$stock           = get_post_meta( $product_id, '_stock', true );
$total_sales     = get_post_meta( $product_id, 'total_sales', true );
$stock_sold      = $total_sales ?: 0;
$stock_available = $stock ?: 0;
$percentage      = $stock_available > 0 ? round( $stock_available / ( $stock_available + $stock_sold ) * 100 ) : 0;

$wrapper_class = 'text-top-position';
if ( 'bottom-position' === ( $settings['wrapper_class'] ?? '' ) ) {
	$wrapper_class = 'text-bottom-position';
}
?>
<?php
if ( $stock && $stock_available > 0 ) {
	?>
	<div class="rtsb-product-stock <?php echo esc_attr( $wrapper_class ); ?>">
		<?php if ( 'yes' === $settings['show_stock_text'] && $settings['stock_text'] ) { ?>
			<span class="stock-sold">
				<?php
				$text = str_replace( '{count}', '<span>' . $stock_available . '</span>', $settings['stock_text'] );
				echo wp_kses_post( $text );
				?>
			</span>
		<?php } if ( 'yes' === $settings['show_stock_progress'] ) { ?>
			<div class="rtsb-stock-progress-wrapper">
				<div class="rtsb-product-stock-progress">
					<span class="rtsb-product-stock-progress-bar" style="width:<?php echo esc_attr( $percentage ); ?>%"></span>
				</div>
			</div>
		<?php } ?>
	</div>
	<?php
}

?>
