<?php
/**
 * Template: Sticky add-to-cart Bar.
 *
 * @package RadiusTheme\SBPRO
 */

/**
 * Template variables:
 *
 * @var $product                 object
 * @var $product_id              int
 * @var $show_thumb              bool
 * @var $show_title              bool
 * @var $heading_tag             string
 * @var $show_qty                bool
 * @var $show_on_variation       bool
 * @var $visibility              string
 * @var $product_image           string
 * @var $product_title           string
 * @var $product_price           string
 * @var $classes                 string
 * @var $scrolling               string
 * @var $button_label            string
 * @var $show_fullwidth          bool
 */

use RadiusTheme\SB\Helpers\Fns;

$GLOBALS['product'] = $product;
?>

<div class="<?php echo esc_attr( $classes ); ?>" data-scrolling-trigger="<?php echo absint( $scrolling ); ?>" data-button-label="<?php echo esc_attr( $button_label ); ?>">
	<?php
	echo $show_fullwidth ? '<div class="rtsb-sticky-cart-wrapper">' : '';
	?>
	<div class="rtsb-row">
		<div class="rtsb-col-grid product-col">
			<div class="rtsb-sticky-content">
				<?php
				if ( $show_thumb ) {
					?>
					<div class="rtsb-sticky-thumb">
						<?php Fns::print_html( $product_image ); ?>
					</div>
					<?php
				}
				?>
				<div class="rtsb-sticky-product">
					<?php
					if ( $show_title ) {
						?>
						<<?php echo esc_attr( $heading_tag ); ?> class="product-title">
							<?php echo esc_html( $product_title ); ?>
						</<?php echo esc_attr( $heading_tag ); ?>>
						<?php
					}
					?>
					<span class="product-price"><?php Fns::print_html( $product_price ); ?></span>
				</div>
			</div>
		</div>
		<div class="rtsb-col-grid button-col">
			<div class="rtsb-sticky-btn">
				<?php
				if ( $product->is_type( 'simple' ) ) {
					woocommerce_simple_add_to_cart();
				} else {
					woocommerce_variable_add_to_cart();
				}
				?>
			</div>
		</div>
	</div>

	<?php
	echo $show_fullwidth ? '</div>' : '';
	?>
</div>
