<?php
/**
 *
 * @var            $product_id           WC_Product id
 * @var array      $available_variations variations array
 * @var array      $attributes           attribute array
 * @var WC_Product $product
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SB\Modules\VariationSwatches\SwatchesFns;


$show_clear                       = 'on' === SwatchesFns::get_options( 'show_clear_on_showcase' );
$enable_showcase_single_attribute = 'on' === SwatchesFns::get_options( 'showcase_single_attribute' );
$chose_showcase_attribute         = SwatchesFns::get_options( 'chose_showcase_single_attribute' );
if ( ! empty( $meta_data['showcase_single_attribute'] ) ) {
	$enable_showcase_single_attribute = true;
	$chose_showcase_attribute         = $meta_data['showcase_single_attribute'];
}
$swatches_align  = SwatchesFns::get_options( 'showcase_swatches_align' );
$variations_json = wp_json_encode( $available_variations );
$variations_attr = function_exists( 'wc_esc_json' ) ? wc_esc_json( $variations_json ) : _wp_specialchars( $variations_json, ENT_QUOTES, 'UTF-8', true );

?>
<div class="variations_form rtsb-product-loop-variation rtsb-showcase-variation-<?php echo esc_attr( $swatches_align ); ?>" data-product_id="<?php echo absint( $product_id ); ?>" data-product_variations="<?php echo $variations_attr; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>">
	<div class="variations">
		<?php
		foreach ( $attributes as $key => $options ) {
			if ( $enable_showcase_single_attribute && $key != $chose_showcase_attribute ) {
				continue;
			}
			$lowerAttributeKey = strtolower( $key );
			$selected          = ! empty( $default_attributes ) && isset( $default_attributes[ $lowerAttributeKey ] ) && $default_attributes[ $lowerAttributeKey ] ? $default_attributes[ $lowerAttributeKey ] : null;
			?>
			<div class="rtsb-variation-terms-wrapper">
			<?php
				Fns::print_html(
					SwatchesFns::generate_variation_attribute_option_html(
						apply_filters(
							'rtsb_vs_variation_attribute_options_args',
							[
								'options'     => $options,
								'attribute'   => $key,
								'product'     => $product,
								'selected'    => $selected,
								'is_showcase' => true,
								'meta_data'   => $meta_data,
							]
						)
					),
					true
				);
			?>
			</div>
			<?php
			if ( $enable_showcase_single_attribute && $key == $chose_showcase_attribute ) {
				break;
			}
		}
		if ( $show_clear && ! $enable_showcase_single_attribute ) :
			echo wp_kses_post( apply_filters( 'woocommerce_reset_variations_link', '<div class="rtsb_showcase_reset_variations"><a class="reset_variations" href="#">' . esc_html__( 'Clear', 'shopbuilder-pro' ) . '</a></div>' ) );
		endif;
		?>
	</div>

</div>